/*
 * Decompiled with CFR 0.152.
 */
package step.core.dynamicbeans;

import java.util.HashMap;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import step.core.dynamicbeans.DynamicValue;
import step.core.dynamicbeans.DynamicValueResolver;
import step.expressions.ExpressionHandler;

public class DynamicValueResolverTest {
    @Test
    public void testString() {
        DynamicValue v1 = new DynamicValue("'test'", "");
        DynamicValueResolver resolver = new DynamicValueResolver(new ExpressionHandler());
        resolver.evaluate(v1, null);
        Assert.assertEquals((Object)"test", (Object)v1.get());
    }

    @Test
    public void testString2() {
        DynamicValue v1 = new DynamicValue("\"test\"", "");
        DynamicValueResolver resolver = new DynamicValueResolver(new ExpressionHandler());
        resolver.evaluate(v1, null);
        Assert.assertEquals((Object)"test", (Object)v1.get());
    }

    @Test
    public void testGString() {
        DynamicValue v1 = new DynamicValue("\"te${'s'}t\"", "");
        DynamicValueResolver resolver = new DynamicValueResolver(new ExpressionHandler());
        resolver.evaluate(v1, null);
        Assert.assertEquals((Object)"test", (Object)v1.get());
    }

    @Test
    public void testGStringVariables() {
        DynamicValue v1 = new DynamicValue("\"t${var}t\"", "");
        DynamicValueResolver resolver = new DynamicValueResolver(new ExpressionHandler());
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("var", "es");
        resolver.evaluate(v1, bindings);
        Assert.assertEquals((Object)"test", (Object)v1.get());
    }

    @Test
    public void testInteger() {
        DynamicValue v1 = new DynamicValue("1", "");
        DynamicValueResolver resolver = new DynamicValueResolver(new ExpressionHandler());
        resolver.evaluate(v1, null);
        Assert.assertEquals((long)1L, (long)((Integer)v1.get()).intValue());
    }

    @Test
    public void testBoolean() {
        DynamicValue v1 = new DynamicValue("true", "");
        DynamicValueResolver resolver = new DynamicValueResolver(new ExpressionHandler());
        resolver.evaluate(v1, null);
        Assert.assertEquals((Object)true, (Object)((Boolean)v1.get()));
    }

    @Test
    public void testJSONObject() {
        DynamicValue v1 = new DynamicValue("new org.json.JSONObject(\"{'key1':'test'}\")", "");
        DynamicValueResolver resolver = new DynamicValueResolver(new ExpressionHandler());
        resolver.evaluate(v1, null);
        Assert.assertEquals((Object)new JSONObject("{'key1':'test'}").get("key1"), (Object)((JSONObject)v1.get()).get("key1"));
    }
}

