/*
 * Decompiled with CFR 0.152.
 */
package step.commons.activation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.activation.ActivableObject;
import step.commons.activation.Expression;

public class Activator {
    private static final String DEFAULT_SCRIPT_ENGINE = "nashorn";
    public static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public static <T extends ActivableObject> List<T> compileActivationExpressions(List<T> objects) throws ScriptException {
        for (ActivableObject object : objects) {
            Activator.compileActivationExpression(object);
        }
        return objects;
    }

    public static void compileActivationExpression(ActivableObject object) throws ScriptException {
        Expression expression = object.getActivationExpression();
        Activator.compileExpression(expression);
    }

    protected static void compileExpression(Expression expression) throws ScriptException {
        if (expression != null && expression.compiledScript == null) {
            String scriptEngine;
            String string = scriptEngine = expression.scriptEngine != null ? expression.scriptEngine : DEFAULT_SCRIPT_ENGINE;
            if (expression.script != null && expression.script.trim().length() > 0) {
                CompiledScript script;
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName(scriptEngine);
                expression.compiledScript = script = ((Compilable)((Object)engine)).compile(expression.script);
            } else {
                expression.compiledScript = null;
            }
        }
    }

    public static Boolean evaluateActivationExpression(Bindings bindings, Expression activationExpression) {
        Boolean expressionResult;
        block9: {
            if (activationExpression != null) {
                try {
                    Activator.compileExpression(activationExpression);
                }
                catch (ScriptException e1) {
                    logger.error("Error while evaluating expression " + activationExpression, (Throwable)e1);
                }
                CompiledScript script = activationExpression.compiledScript;
                if (script != null) {
                    try {
                        Object evaluationResult = script.eval(bindings);
                        if (evaluationResult instanceof Boolean) {
                            expressionResult = (Boolean)evaluationResult;
                            break block9;
                        }
                        expressionResult = false;
                    }
                    catch (ScriptException e) {
                        expressionResult = false;
                    }
                } else {
                    expressionResult = true;
                }
            } else {
                expressionResult = true;
            }
        }
        return expressionResult;
    }

    public static <T extends ActivableObject> T findBestMatch(Map<String, Object> bindings, List<T> objects) {
        return Activator.findBestMatch(bindings != null ? new SimpleBindings(bindings) : null, objects);
    }

    private static <T extends ActivableObject> T findBestMatch(Bindings bindings, List<T> objects) {
        ArrayList<T> matchingObjects = new ArrayList<T>(objects);
        matchingObjects.sort(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -Integer.compare(this.getPriority(o1), this.getPriority(o2));
            }

            private int getPriority(T o1) {
                return o1.getActivationExpression() == null ? 0 : (o1.getPriority() == null ? 1 : o1.getPriority());
            }
        });
        for (ActivableObject object : matchingObjects) {
            if (!Activator.evaluateActivationExpression(bindings, object.getActivationExpression()).booleanValue()) continue;
            return (T)object;
        }
        return null;
    }

    public static <T extends ActivableObject> List<T> findAllMatches(Map<String, Object> bindings, List<T> objects) {
        ArrayList<ActivableObject> result = new ArrayList<ActivableObject>();
        Iterator<T> iterator = objects.iterator();
        while (iterator.hasNext()) {
            ActivableObject object;
            Boolean expressionResult = Activator.evaluateActivationExpression(bindings != null ? new SimpleBindings(bindings) : null, (object = (ActivableObject)iterator.next()).getActivationExpression());
            if (!expressionResult.booleanValue()) continue;
            result.add(object);
        }
        return result;
    }
}

