/*
 * Decompiled with CFR 0.152.
 */
package step.commons.conf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.helpers.FileHelper;

public class FileWatchService
extends Thread
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FileWatchService.class);
    private final HashMap<File, Subscription> subscriptions = new HashMap();
    private int interval = 1000;
    private static FileWatchService INSTANCE = new FileWatchService();
    private volatile boolean running = true;

    public static FileWatchService getInstance() {
        return INSTANCE;
    }

    private FileWatchService() {
        this.start();
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        super.run();
        try {
            while (this.running) {
                Thread.sleep(this.interval);
                HashMap<File, Subscription> hashMap = this.subscriptions;
                synchronized (hashMap) {
                    for (Map.Entry<File, Subscription> entry : this.subscriptions.entrySet()) {
                        long lastModificationDate = FileHelper.getLastModificationDateRecursive(entry.getKey());
                        if (lastModificationDate <= entry.getValue().lastupdate) continue;
                        logger.info("Reloading file: " + entry.getKey().getAbsolutePath());
                        entry.getValue().lastupdate = lastModificationDate;
                        try {
                            entry.getValue().callback.run();
                        }
                        catch (Exception e) {
                            logger.error("An error occurred while calling callback for file " + entry.getKey(), (Throwable)e);
                        }
                    }
                }
            }
            return;
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted", (Throwable)e);
        }
    }

    public void register(File file, Runnable callback) {
        this.register(file, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(File file, Runnable callback, boolean callOnRegistration) {
        HashMap<File, Subscription> hashMap = this.subscriptions;
        synchronized (hashMap) {
            logger.debug("Registering file " + file);
            this.subscriptions.put(file, new Subscription(callOnRegistration ? 0L : FileHelper.getLastModificationDateRecursive(file), callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(File file) {
        HashMap<File, Subscription> hashMap = this.subscriptions;
        synchronized (hashMap) {
            logger.debug("Unregistering file " + file);
            this.subscriptions.remove(file);
        }
    }

    @Override
    public void close() throws IOException {
        this.running = false;
    }

    private class Subscription {
        long lastupdate;
        Runnable callback;

        public Subscription(long lastupdate, Runnable callback) {
            this.lastupdate = lastupdate;
            this.callback = callback;
        }
    }
}

