/*
 * Decompiled with CFR 0.152.
 */
package step.commons.conf;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.conf.FileWatchService;

public class FileRepository<T> {
    private File configFile;
    private TypeReference<T> typeRef;
    private Class<T> objectClass;
    private FileRepositoryCallback<T> callback;
    private static Logger logger = LoggerFactory.getLogger(FileRepository.class);

    public FileRepository(File file, Class<T> objectClass, FileRepositoryCallback<T> callback) {
        this.objectClass = objectClass;
        this.callback = callback;
        this.configFile = file;
        this.init();
    }

    public FileRepository(File file, TypeReference<T> typeRef, FileRepositoryCallback<T> callback) {
        this.typeRef = typeRef;
        this.callback = callback;
        this.configFile = file;
        this.init();
    }

    public void init() {
        this.loadConfigAndCallback();
        FileWatchService.getInstance().register(this.configFile, new Runnable(){

            @Override
            public void run() {
                FileRepository.this.loadConfigAndCallback();
            }
        });
    }

    public void destroy() {
        FileWatchService.getInstance().unregister(this.configFile);
    }

    private void loadConfigAndCallback() {
        try {
            T object = this.parseConfig();
            this.callback.onLoad(object);
        }
        catch (Exception e) {
            logger.error("Error while loading loading configuration file '" + this.configFile.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T parseConfig() throws IOException {
        try (FileInputStream stream = new FileInputStream(this.configFile);){
            ObjectMapper mapper = new ObjectMapper();
            if (this.objectClass != null) {
                Object object = mapper.readValue((InputStream)stream, this.objectClass);
                return (T)object;
            }
            Object object = mapper.readValue((InputStream)stream, this.typeRef);
            return (T)object;
        }
    }

    public void save(T config) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.writeValue(this.configFile, config);
    }

    public static interface FileRepositoryCallback<T> {
        public void onLoad(T var1) throws Exception;
    }
}

