/*
 * Decompiled with CFR 0.152.
 */
package step.commons.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.conf.FileWatchService;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static Configuration INSTANCE = new Configuration();
    private File propertyFile;
    private Properties properties;

    public Configuration() {
        this.properties = new Properties();
    }

    public Configuration(File propertyFile) {
        this.propertyFile = propertyFile;
        try {
            this.load();
        }
        catch (Exception e) {
            logger.error("Error while loading configuration.", (Throwable)e);
        }
        if (this.getPropertyAsBoolean("conf.scan", false)) {
            FileWatchService.getInstance().register(propertyFile, new Runnable(){

                @Override
                public void run() {
                    try {
                        Configuration.this.load();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    public void load() throws FileNotFoundException, IOException {
        this.properties = new Properties();
        if (this.propertyFile != null) {
            this.properties.load(new FileReader(this.propertyFile));
        }
    }

    public static void setInstance(Configuration instance) {
        INSTANCE = instance;
    }

    public static Configuration getInstance() {
        return INSTANCE;
    }

    public Object put(Object arg0, Object arg1) {
        return this.properties.put(arg0, arg1);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public void putProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Integer getPropertyAsInteger(String name) {
        return this.getPropertyAsInteger(name, null);
    }

    public Integer getPropertyAsInteger(String name, Integer defaultValue) {
        String prop = this.properties.getProperty(name);
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return defaultValue;
    }

    public Long getPropertyAsLong(String name, Long defaultValue) {
        String prop = this.properties.getProperty(name);
        if (prop != null) {
            return Long.parseLong(prop);
        }
        return defaultValue;
    }

    public boolean getPropertyAsBoolean(String name) {
        return this.getPropertyAsBoolean(name, false);
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        String prop = this.properties.getProperty(name);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return defaultValue;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }
}

