/*
 * Decompiled with CFR 0.152.
 */
package step.commons.processmanager;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.conf.Configuration;
import step.commons.helpers.FileHelper;

public class ManagedProcess
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ManagedProcess.class);
    private final ProcessBuilder builder;
    private static File logFolder;
    private File processOutputLog;
    private File processErrorLog;
    private final String id;
    private Process process;
    private File executionDirectory;

    public ManagedProcess(String command, String name) throws ManagedProcessException {
        this(ManagedProcess.tokenize(command), name);
    }

    public ManagedProcess(String name, String ... command) throws ManagedProcessException {
        this(Arrays.asList(command), name);
    }

    public ManagedProcess(List<String> commands, String name) throws ManagedProcessException {
        this(null, commands, name);
    }

    public ManagedProcess(File executionDirectory, List<String> commands, String name) throws ManagedProcessException {
        String logdir = Configuration.getInstance().getProperty("managedprocesses.logdir");
        logFolder = new File(logdir != null ? logdir : ".");
        UUID uuid = UUID.randomUUID();
        this.id = name + "_" + uuid;
        this.builder = new ProcessBuilder(commands);
        if (executionDirectory == null && !(executionDirectory = new File(logFolder + "/" + this.id)).exists() && !executionDirectory.mkdir()) {
            throw new InvalidParameterException("Unable to create log folder for process " + this.id + ". Please ensure that the folder specified by the parameter adapters.log in the configuration repository exists and is writable.");
        }
        this.executionDirectory = executionDirectory;
    }

    public static File getLogFolder() {
        return logFolder;
    }

    public File getProcessOutputLog() {
        return this.processOutputLog;
    }

    public File getProcessErrorLog() {
        return this.processErrorLog;
    }

    public File getExecutionDirectory() {
        return this.executionDirectory;
    }

    public void setExecutionDirectory(File executionDirectory) {
        this.executionDirectory = executionDirectory;
    }

    private static List<String> tokenize(String command) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");
        Matcher regexMatcher = regex.matcher(command);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                tokens.add(regexMatcher.group(1));
                continue;
            }
            tokens.add(regexMatcher.group());
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ManagedProcessException {
        ManagedProcess managedProcess = this;
        synchronized (managedProcess) {
            if (this.process == null) {
                logger.debug("Starting managed process " + this.builder.command());
                this.builder.directory(this.executionDirectory);
                this.processOutputLog = new File(this.executionDirectory + "/ProcessOut.log");
                this.builder.redirectOutput(this.processOutputLog);
                this.processErrorLog = new File(this.executionDirectory + "/ProcessError.log");
                this.builder.redirectError(this.processErrorLog);
                try {
                    this.process = this.builder.start();
                }
                catch (IOException e) {
                    throw new ManagedProcessException("Unable to start the process " + this.id, e);
                }
            } else {
                throw new ManagedProcessException("Unable to the process " + this.id + ". Process already runnning.");
            }
            logger.debug("Started managed process " + this.builder.command());
        }
    }

    public void waitFor(long timeout) throws TimeoutException, InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Integer> ft = executor.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ManagedProcess.this.process.waitFor();
                return ManagedProcess.this.process.exitValue();
            }
        });
        executor.shutdown();
        ft.get(timeout, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        FileHelper.deleteFolder(this.executionDirectory);
    }

    @Override
    public void close() throws IOException {
        this.destroy();
    }

    public class ManagedProcessException
    extends Exception {
        private static final long serialVersionUID = -2205566982535606557L;

        public ManagedProcessException(String message, Throwable cause) {
            super(message, cause);
        }

        public ManagedProcessException(String message) {
            super(message);
        }
    }
}

