/*
 * Decompiled with CFR 0.152.
 */
package step.commons.helpers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.conf.Configuration;

public class FileHelper {
    private static final Logger logger = LoggerFactory.getLogger(FileHelper.class);
    static LoadingCache<File, Long> cache = CacheBuilder.newBuilder().concurrencyLevel(Configuration.getInstance().getPropertyAsInteger("filehelper.cache.concurrencylevel", 4).intValue()).maximumSize((long)Configuration.getInstance().getPropertyAsInteger("filehelper.cache.maximumsize", 1000).intValue()).expireAfterWrite((long)Configuration.getInstance().getPropertyAsInteger("filehelper.cache.expireafter.seconds", 1).intValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<File, Long>(){

        public Long load(File file) {
            return FileHelper.computeLastModification(file);
        }
    });

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileHelper.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public static void deleteFolderOnExit(File folder) {
        folder.deleteOnExit();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileHelper.deleteFolderOnExit(f);
                    continue;
                }
                f.deleteOnExit();
            }
        }
    }

    public static final long getLastModificationDateRecursive(File file) {
        try {
            return (Long)cache.get((Object)file);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while getting last modification date for file '" + file.getAbsolutePath() + "' from cache", e);
        }
    }

    protected static final long computeLastModification(File file) {
        return FileHelper.computeLastModificationDateRecursive(file);
    }

    protected static final long computeLastModificationDateRecursive(File file) {
        if (file.isDirectory()) {
            long lastModificationDate = file.lastModified();
            for (File f : file.listFiles()) {
                long lastChange = FileHelper.computeLastModificationDateRecursive(f);
                if (lastChange <= lastModificationDate) continue;
                lastModificationDate = lastChange;
            }
            return lastModificationDate;
        }
        return file.lastModified();
    }

    public static final void zipDirectory(File directory, File zip) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
        FileHelper.zip(directory, directory, zos);
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFolder(byte[] bytes, File target) {
        ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(bytes));
        try {
            ZipEntry entry;
            int BUFFER = 2048;
            target.mkdir();
            while ((entry = zip.getNextEntry()) != null) {
                int currentByte;
                String currentEntry = entry.getName();
                File destFile = new File(target.getAbsolutePath(), currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                while ((currentByte = zip.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
            }
        }
        catch (Exception e) {
            logger.error("Error while extracting folder " + target.getAbsolutePath(), (Throwable)e);
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final byte[] zipDirectory(File directory) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(out);
        FileHelper.zip(directory, directory, zos);
        zos.close();
        return out.toByteArray();
    }

    private static final void zip(File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                FileHelper.zip(files[i], base, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            ZipEntry entry = new ZipEntry(files[i].getPath().substring(base.getPath().length() + 1));
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
    }

    public static void zip(String sourceDir, String zipFile) {
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            FileHelper.addDirectory(zout, fileSource);
            zout.close();
        }
        catch (IOException ioe) {
            System.out.println("IOException :" + ioe);
        }
    }

    private static void addDirectory(ZipOutputStream zout, File fileSource) {
        File[] files = fileSource.listFiles();
        System.out.println("Adding directory " + fileSource.getName());
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileHelper.addDirectory(zout, files[i]);
                continue;
            }
            try {
                int length;
                System.out.println("Adding file " + files[i].getName());
                byte[] buffer = new byte[1024];
                FileInputStream fin = new FileInputStream(files[i]);
                zout.putNextEntry(new ZipEntry(files[i].getName()));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IOException :" + ioe);
            }
        }
    }

    public static File getClassLoaderResource(Class<?> clazz, String resourceName) {
        try {
            URL url = clazz.getClassLoader().getResource(resourceName);
            return url != null ? new File(url.toURI().getPath()) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error while parsing URI of resource " + resourceName, e);
        }
    }
}

