/*
 * Decompiled with CFR 0.152.
 */
package step.commons.buffering;

import java.util.Iterator;
import step.commons.buffering.TreeIteratorFactory;

public class TreeIterator<T>
implements Iterator<T> {
    final Iterator<T> it;
    final TreeIteratorFactory<T> factory;
    Iterator<T> childrenIt = null;

    public TreeIterator(Iterator<T> it, TreeIteratorFactory<T> factory) {
        this.it = it;
        this.factory = factory;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext() || this.childrenIt != null && this.childrenIt.hasNext();
    }

    @Override
    public T next() {
        if (this.childrenIt == null || !this.childrenIt.hasNext()) {
            T nextParent = this.it.next();
            this.childrenIt = new TreeIterator<T>(this.factory.getChildrenIterator(nextParent), this.factory);
            return nextParent;
        }
        return this.childrenIt.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove method not supported!");
    }
}

