/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.functions.types;

import java.util.HashMap;
import java.util.Map;
import step.artefacts.Sequence;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.ArtefactManager;
import step.functions.Function;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeException;
import step.functions.type.SetupFunctionException;
import step.plugins.functions.types.CompositeFunction;
import step.plugins.functions.types.composite.ArtefactFunctionHandler;

public class CompositeFunctionType
extends AbstractFunctionType<CompositeFunction> {
    public static final String ARTEFACTID_KEY = "$artefactid";
    private final ArtefactAccessor artefactAccessor;
    private final ArtefactManager artefactManager;

    public CompositeFunctionType(ArtefactAccessor artefactAccessor, ArtefactManager artefactManager) {
        this.artefactAccessor = artefactAccessor;
        this.artefactManager = artefactManager;
    }

    public void init() {
        super.init();
    }

    public String getHandlerChain(CompositeFunction function) {
        return ArtefactFunctionHandler.class.getName();
    }

    public Map<String, String> getHandlerProperties(CompositeFunction function) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(ARTEFACTID_KEY, function.getArtefactId());
        return props;
    }

    public void setupFunction(CompositeFunction function) throws SetupFunctionException {
        super.setupFunction((Function)function);
        Sequence sequence = new Sequence();
        this.artefactAccessor.save((AbstractIdentifiableObject)sequence);
        function.setArtefactId(sequence.getId().toString());
    }

    public CompositeFunction copyFunction(CompositeFunction function) throws FunctionTypeException {
        CompositeFunction copy = (CompositeFunction)super.copyFunction((Function)function);
        String artefactId = function.getArtefactId();
        AbstractArtefact artefactCopy = this.artefactManager.copyArtefact(artefactId);
        copy.setArtefactId(artefactCopy.getId().toString());
        return copy;
    }

    public CompositeFunction newFunction() {
        return new CompositeFunction();
    }
}

