/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.functions.types.composite;

import javax.json.JsonObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.reports.Error;
import step.core.reports.ErrorType;
import step.core.variables.VariableType;
import step.functions.handler.JsonBasedFunctionHandler;
import step.functions.io.Input;
import step.functions.io.Output;
import step.functions.io.OutputBuilder;

public class ArtefactFunctionHandler
extends JsonBasedFunctionHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Output<JsonObject> handle(Input<JsonObject> input) {
        ExecutionContext executionContext = (ExecutionContext)this.getTokenReservationSession().get("$executionContext");
        String artefactId = (String)input.getProperties().get("$artefactid");
        String parentReportId = (String)input.getProperties().get("$parentreportid");
        if (parentReportId == null) {
            throw new RuntimeException("Parent node id is null. This should never occur");
        }
        ReportNode parentNode = executionContext.getReportNodeAccessor().get(parentReportId);
        ReportNode previousCurrentNode = executionContext.getCurrentReportNode();
        executionContext.setCurrentReportNode(parentNode);
        executionContext.getReportNodeCache().put(parentNode);
        AbstractArtefact artefact = executionContext.getArtefactAccessor().get(artefactId);
        executionContext.getVariablesManager().putVariable(parentNode, "input", input.getPayload());
        OutputBuilder output = new OutputBuilder();
        executionContext.getVariablesManager().putVariable(parentNode, VariableType.IMMUTABLE, "output", (Object)output);
        try {
            ReportNode node = ArtefactHandler.delegateExecute((ExecutionContext)executionContext, (AbstractArtefact)artefact, (ReportNode)parentNode);
            if (node.getStatus() == ReportNodeStatus.TECHNICAL_ERROR || node.getStatus() == ReportNodeStatus.FAILED) {
                Error error = new Error();
                error.setCode(Integer.valueOf(0));
                error.setMsg("Error in composite keyword");
                error.setRoot(false);
                error.setType(node.getStatus().equals((Object)ReportNodeStatus.FAILED) ? ErrorType.BUSINESS : ErrorType.TECHNICAL);
                output.setError(error);
            }
            Output output2 = output.build();
            return output2;
        }
        finally {
            executionContext.getVariablesManager().removeVariable(parentNode, "output");
            executionContext.setCurrentReportNode(previousCurrentNode);
        }
    }
}

