/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.views;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import step.core.GlobalContext;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.plugins.views.AbstractView;
import step.plugins.views.View;
import step.plugins.views.ViewModel;
import step.plugins.views.ViewModelAccessor;
import step.plugins.views.ViewPluginServices;

@Plugin
public class ViewPlugin
extends AbstractPlugin {
    public static final String VIEW_PLUGIN_KEY = "ViewPlugin_Instance";
    private final ConcurrentHashMap<String, AbstractView<ViewModel>> register = new ConcurrentHashMap();
    private ViewModelAccessor accessor;

    public void executionControllerStart(GlobalContext context) {
        this.loadViews();
        this.accessor = new ViewModelAccessor(context.getMongoClientSession());
        context.getServiceRegistrationCallback().registerService(ViewPluginServices.class);
        context.put(VIEW_PLUGIN_KEY, (Object)this);
    }

    private void loadViews() {
        Set viewClasses = new Reflections("step", new Scanner[0]).getTypesAnnotatedWith(View.class);
        for (Class viewClass : viewClasses) {
            try {
                AbstractView view = (AbstractView)viewClass.newInstance();
                this.register(view.getViewId(), view);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {}
        }
    }

    public void register(String viewId, AbstractView<ViewModel> view) {
        this.register.put(viewId, view);
    }

    public ViewModel query(String viewId, String executionId) {
        AbstractView<ViewModel> view = this.register.get(viewId);
        if (view != null) {
            ViewModel model = view.getModel(executionId);
            if (model == null) {
                model = this.accessor.get(viewId, executionId, ViewModel.class);
                if (model != null) {
                    return model;
                }
                return view.init();
            }
            return model;
        }
        throw new RuntimeException("Invalid view id: " + viewId);
    }

    public void executionStart(ExecutionContext context) {
        for (AbstractView<ViewModel> view : this.register.values()) {
            ViewModel model = view.init();
            model.setExecutionId(context.getExecutionId());
            model.setViewId(view.getViewId());
            view.addModel(context.getExecutionId(), model);
        }
    }

    public void afterExecutionEnd(ExecutionContext context) {
        for (AbstractView<ViewModel> view : this.register.values()) {
            ViewModel model = view.removeModel(context.getExecutionId());
            this.accessor.save(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterReportNodeSkeletonCreation(ReportNode node) {
        for (AbstractView<ViewModel> view : this.register.values()) {
            ViewModel model;
            ViewModel viewModel = model = view.getModel(node.getExecutionID());
            synchronized (viewModel) {
                view.afterReportNodeSkeletonCreation(model, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterReportNodeExecution(ReportNode node) {
        for (AbstractView<ViewModel> view : this.register.values()) {
            ViewModel model;
            ViewModel viewModel = model = view.getModel(node.getExecutionID());
            synchronized (viewModel) {
                view.afterReportNodeExecution(model, node);
            }
        }
    }
}

