/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.functions.types.composite;

import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.variables.VariableType;
import step.grid.agent.handler.MessageHandler;
import step.grid.agent.handler.context.OutputMessageBuilder;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;

public class ArtefactMessageHandler
implements MessageHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputMessage handle(AgentTokenWrapper token, InputMessage message) throws Exception {
        ExecutionContext executionContext = (ExecutionContext)token.getToken().getAttachedObject((Object)"$executionContext");
        String artefactId = (String)message.getProperties().get("$artefactid");
        String parentReportId = (String)message.getProperties().get("$parentreportid");
        ReportNode parentNode = new ReportNode();
        if (parentReportId != null) {
            parentNode.setParentID(new ObjectId(parentReportId));
        }
        parentNode.setExecutionID(executionContext.getExecutionId());
        executionContext.getReportNodeAccessor().save((AbstractIdentifiableObject)parentNode);
        ReportNode previousCurrentNode = executionContext.getCurrentReportNode();
        executionContext.setCurrentReportNode(parentNode);
        executionContext.getReportNodeCache().put(parentNode);
        AbstractArtefact artefact = executionContext.getArtefactAccessor().get(artefactId);
        executionContext.getVariablesManager().putVariable(parentNode, "input", (Object)message.getArgument());
        OutputMessageBuilder output = new OutputMessageBuilder();
        executionContext.getVariablesManager().putVariable(parentNode, VariableType.IMMUTABLE, "output", (Object)output);
        try {
            ReportNode node = ArtefactHandler.delegateExecute((ExecutionContext)executionContext, (AbstractArtefact)artefact, (ReportNode)parentNode);
            if (node.getStatus() == ReportNodeStatus.TECHNICAL_ERROR || node.getStatus() == ReportNodeStatus.FAILED) {
                output.setError("Error in composite execution. Composite status: " + node.getStatus() + (node.getError() != null ? ". Error message: " + node.getError().getMsg() : ""));
            }
            OutputMessage outputMessage = output.build();
            return outputMessage;
        }
        finally {
            executionContext.getVariablesManager().removeVariable(parentNode, "output");
            executionContext.setCurrentReportNode(previousCurrentNode);
        }
    }
}

