/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.events;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import step.plugins.events.Event;

public class EventBroker {
    private ConcurrentHashMap<String, Event> events = new ConcurrentHashMap();

    public Event put(Event event) {
        if (event == null || event.getId() == null || event.getId().isEmpty()) {
            String uuid = UUID.randomUUID().toString();
            this.events.put(uuid, event.setId(uuid));
        }
        this.events.put(event.getId(), event);
        return event;
    }

    public void clear() {
        this.events.clear();
    }

    public Event get(String id) {
        if (!this.hasEvent(id)) {
            return null;
        }
        return this.events.get(id).setLastReadTimestamp(System.currentTimeMillis());
    }

    public boolean hasEvent(String id) {
        if (id == null) {
            return false;
        }
        return this.events.containsKey(id);
    }

    public boolean hasEvent(String group, String name) {
        return this.hasEvent(this.lookup(group, name));
    }

    public Event get(String group, String name) {
        return this.get(this.lookup(group, name));
    }

    public void remove(String id) {
        this.events.remove(id);
    }

    public void remove(String group, String name) {
        this.remove(this.lookup(group, name));
    }

    public String lookup(String group, String name) {
        if (group == null) {
            throw new RuntimeException("group can not be null.");
        }
        String id = null;
        try {
            id = this.events.values().stream().filter(v -> {
                if (v.getGroup().equals(group)) {
                    if (name == null || name.isEmpty()) {
                        return true;
                    }
                    if (v.getName().equals(name)) {
                        return true;
                    }
                }
                return false;
            }).findAny().get().getId();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return id;
    }

    public String toString() {
        return this.events.toString();
    }

    public void clearGroup(String group) {
        while (this.hasEvent(group, null)) {
            this.remove(this.lookup(group, null));
        }
    }

    public Map<String, Event> asMap() {
        return this.events;
    }
}

