/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.quotamanager;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.codehaus.groovy.runtime.InvokerHelper;
import step.plugins.quotamanager.QuotaHandlerStatus;
import step.plugins.quotamanager.QuotaSemaphore;
import step.plugins.quotamanager.config.Quota;

public class QuotaHandler {
    private ConcurrentHashMap<String, QuotaSemaphore> semaphores = new ConcurrentHashMap();
    private Quota config;
    private Class<?> scriptClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuotaHandler(Quota config) {
        this.config = config;
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader();
        try {
            this.scriptClass = groovyClassLoader.parseClass(config.getQuotaKeyFunction());
        }
        finally {
            try {
                groovyClassLoader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Quota getConfig() {
        return this.config;
    }

    public String acquirePermit(Map<String, Object> bindingVariables) throws Exception {
        String quotaKey = this.computeQuotaKey(bindingVariables);
        if (quotaKey != null) {
            QuotaSemaphore semaphore = this.getOrCreateSemaphore(quotaKey);
            if (this.config.getAcquireTimeoutMs() != null) {
                boolean acquired = semaphore.tryAcquire(this.config.getAcquireTimeoutMs(), TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new TimeoutException("A timeout occurred while trying to acquire permit for quota: " + this.config.toString());
                }
                semaphore.incrementLoad();
            } else {
                semaphore.acquire();
                semaphore.incrementLoad();
            }
        }
        return quotaKey;
    }

    public String tryAcquirePermit(Map<String, Object> bindingVariables, long timeout) throws Exception {
        String quotaKey = this.computeQuotaKey(bindingVariables);
        if (quotaKey != null) {
            QuotaSemaphore semaphore = this.getOrCreateSemaphore(quotaKey);
            boolean acquired = semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (!acquired) {
                throw new TimeoutException("A timeout occurred while trying to acquire permit for quota: " + this.config.toString());
            }
            semaphore.incrementLoad();
        }
        return quotaKey;
    }

    public void releasePermit(String quotaKey) {
        QuotaSemaphore semaphore = this.getOrCreateSemaphore(quotaKey);
        semaphore.decrementLoad();
        semaphore.release();
    }

    private QuotaSemaphore getOrCreateSemaphore(String key) {
        QuotaSemaphore newInstance;
        QuotaSemaphore semaphore = this.semaphores.get(key);
        if (semaphore == null && (semaphore = this.semaphores.putIfAbsent(key, newInstance = new QuotaSemaphore(this.config.getPermits(), false))) == null) {
            semaphore = newInstance;
        }
        return semaphore;
    }

    protected String computeQuotaKey(Map<String, Object> bindingVariables) throws Exception {
        Binding binding = new Binding(bindingVariables);
        Script script = InvokerHelper.createScript(this.scriptClass, (Binding)binding);
        Object result = script.run();
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public QuotaHandlerStatus getStatus() {
        QuotaHandlerStatus status = new QuotaHandlerStatus();
        status.permitsByQuotaKey = this.config.getPermits();
        status.configuration = this.config;
        for (Map.Entry<String, QuotaSemaphore> entry : this.semaphores.entrySet()) {
            int peak = entry.getValue().getPeak();
            int usage = this.config.getPermits() - entry.getValue().availablePermits();
            status.addEntry(entry.getKey(), usage, peak);
        }
        return status;
    }
}

