/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.quotamanager;

import java.io.StringWriter;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import step.core.deployment.AbstractServices;
import step.plugins.quotamanager.QuotaHandlerStatus;
import step.plugins.quotamanager.QuotaManager;

@Path(value="/quotamanager")
public class QuotaManagerServices
extends AbstractServices {
    @GET
    @Path(value="/status")
    @Produces(value={"text/plain"})
    public String getQuotaManagerStatus() {
        StringWriter writer = new StringWriter();
        QuotaManager quotaManager = (QuotaManager)this.getContext().get(QuotaManager.class);
        if (quotaManager != null) {
            writer.write("QuotaManager status:\n");
            for (QuotaHandlerStatus status : quotaManager.getStatus()) {
                writer.write("  Quota \"" + status.getConfiguration().getId() + "\" (" + status.getConfiguration().getDescription() + "):\n");
                for (QuotaHandlerStatus.QuotaHandlerStatusEntry quotaKeyStatus : status.getEntries()) {
                    String peakDisplay = quotaKeyStatus.getUsage() > quotaKeyStatus.getPeak() ? "n.a." : Integer.toString(quotaKeyStatus.getPeak());
                    writer.write("    Key \"" + quotaKeyStatus.getQuotaKey() + "\". Quota usage: " + quotaKeyStatus.getUsage() + "/" + status.getConfiguration().getPermits() + " (Peak: " + peakDisplay + ")\n");
                }
            }
        } else {
            writer.write("The quota manager is disabled. You can enable it by setting the property quotamanager.config in the step configuration.");
        }
        return writer.toString();
    }
}

