/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.functions.types;

import java.util.HashMap;
import java.util.Map;
import step.artefacts.Sequence;
import step.core.artefacts.AbstractArtefact;
import step.functions.Function;
import step.functions.editors.FunctionEditor;
import step.functions.editors.FunctionEditorRegistry;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeException;
import step.functions.type.SetupFunctionException;
import step.plugins.functions.types.CompositeFunction;
import step.plugins.functions.types.composite.ArtefactMessageHandler;

public class CompositeFunctionType
extends AbstractFunctionType<CompositeFunction> {
    public void init() {
        super.init();
        ((FunctionEditorRegistry)this.context.get(FunctionEditorRegistry.class)).register(new FunctionEditor(){

            public String getEditorPath(Function function) {
                return "/root/artefacteditor/" + ((CompositeFunction)function).getArtefactId();
            }

            public boolean isValidForFunction(Function function) {
                return function instanceof CompositeFunction;
            }
        });
    }

    public String getHandlerChain(CompositeFunction function) {
        return ArtefactMessageHandler.class.getName();
    }

    public Map<String, String> getHandlerProperties(CompositeFunction function) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("$artefactid", function.getArtefactId());
        return props;
    }

    public void setupFunction(CompositeFunction function) throws SetupFunctionException {
        super.setupFunction((Function)function);
        Sequence sequence = new Sequence();
        this.context.getArtefactAccessor().save((AbstractArtefact)sequence);
        function.setArtefactId(sequence.getId().toString());
    }

    public CompositeFunction copyFunction(CompositeFunction function) throws FunctionTypeException {
        CompositeFunction copy = (CompositeFunction)super.copyFunction((Function)function);
        String artefactId = function.getArtefactId();
        AbstractArtefact artefactCopy = this.context.getArtefactManager().copyArtefact(artefactId);
        copy.setArtefactId(artefactCopy.getId().toString());
        return copy;
    }

    public CompositeFunction newFunction() {
        return new CompositeFunction();
    }
}

