/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.views.functions;

import java.util.Map;
import java.util.TreeMap;
import step.plugins.views.AbstractView;
import step.plugins.views.functions.AbstractTimeBasedModel;

public abstract class AbstractTimeBasedView<T>
extends AbstractView<AbstractTimeBasedModel<T>> {
    int[] resolutions = new int[]{5000, 60000, 3600000, 86400000};
    int threshold = 20;

    @Override
    public AbstractTimeBasedModel<T> init() {
        AbstractTimeBasedModel model = new AbstractTimeBasedModel();
        model.setIntervals(new TreeMap());
        model.setResolution(this.resolutions[0]);
        model.setResolutionIndex(0);
        return model;
    }

    public void setResolutions(int[] resolutions) {
        this.resolutions = resolutions;
    }

    protected void addPoint(AbstractTimeBasedModel<T> model, long time, T point) {
        this.decreaseResolutionIfNeeded(model);
        this.addPointToInterval(model.getIntervals(), time, model.getResolution(), point);
        this.updateMinAndMaxTime(model, time);
    }

    private void updateMinAndMaxTime(AbstractTimeBasedModel<T> model, long time) {
        if (model.getMinTime() > time) {
            model.setMinTime(time);
        }
        if (model.getMaxTime() < time) {
            model.setMaxTime(time);
        }
    }

    private void decreaseResolutionIfNeeded(AbstractTimeBasedModel<T> model) {
        if (model.getIntervals().size() > this.threshold) {
            this.decreaseResolution(model);
        }
    }

    private void decreaseResolution(AbstractTimeBasedModel<T> model) {
        int resolutionIndex = Math.min(model.getResolutionIndex() + 1, this.resolutions.length - 1);
        int resolution = this.resolutions[resolutionIndex];
        TreeMap newIntervals = new TreeMap();
        TreeMap<Long, T> oldIntervals = model.getIntervals();
        for (Map.Entry<Long, T> entry : oldIntervals.entrySet()) {
            long time = entry.getKey();
            this.addPointToInterval(newIntervals, time, resolution, entry.getValue());
        }
        model.setResolutionIndex(resolutionIndex);
        model.setResolution(resolution);
        model.setIntervals(newIntervals);
    }

    private void addPointToInterval(Map<Long, T> intervals, long time, int resolution, T point) {
        long interval = this.timeToInterval(time, resolution);
        T entry = intervals.get(interval);
        if (entry == null) {
            entry = point;
            intervals.put(interval, entry);
        } else {
            this.mergePoints(entry, point);
        }
    }

    protected abstract void mergePoints(T var1, T var2);

    private long timeToInterval(long time, long resolution) {
        return time - time % resolution;
    }
}

