/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.CRUDAccessor;
import step.core.accessors.Collection;
import step.core.accessors.CollectionRegistry;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionContextBindings;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.core.variables.VariableType;
import step.core.variables.VariablesManager;
import step.plugins.parametermanager.Parameter;
import step.plugins.parametermanager.ParameterCollection;
import step.plugins.parametermanager.ParameterManager;
import step.plugins.parametermanager.ParameterServices;

@Plugin(prio=10)
public class ParameterManagerPlugin
extends AbstractPlugin {
    public static Logger logger = LoggerFactory.getLogger(ParameterManagerPlugin.class);

    public void executionControllerStart(GlobalContext context) {
        AbstractCRUDAccessor parameterAccessor = new AbstractCRUDAccessor(context.getMongoClientSession(), "parameters", Parameter.class);
        context.put("ParameterAccessor", (Object)parameterAccessor);
        ((CollectionRegistry)context.get(CollectionRegistry.class)).register("parameters", (Collection)new ParameterCollection(context.getMongoDatabase()));
        ParameterManager parameterManager = new ParameterManager((CRUDAccessor<Parameter>)parameterAccessor);
        context.put(ParameterManager.class, (Object)parameterManager);
        context.getServiceRegistrationCallback().registerService(ParameterServices.class);
    }

    public void executionStart(ExecutionContext context) {
        ParameterManager parameterManager = (ParameterManager)context.getGlobalContext().get(ParameterManager.class);
        if (parameterManager != null) {
            ReportNode rootNode = context.getReport();
            VariablesManager varMan = context.getVariablesManager();
            varMan.putVariable(rootNode, VariableType.IMMUTABLE, "user", (Object)context.getExecutionParameters().getUserID());
            ParameterManagerPlugin.putVariables(context, rootNode, context.getExecutionParameters().getCustomParameters(), VariableType.IMMUTABLE);
            Map<String, String> parameters = parameterManager.getAllParameters(ExecutionContextBindings.get((ExecutionContext)context));
            ParameterManagerPlugin.putVariables(context, rootNode, parameters, VariableType.IMMUTABLE);
        } else {
            logger.warn("Not able to read parameters. ParameterManager has not been initialized during controller start.");
        }
        super.executionStart(context);
    }

    public static void putVariables(ExecutionContext context, ReportNode rootNode, Map<String, ? extends Object> parameters, VariableType type) {
        VariablesManager varMan = context.getVariablesManager();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                varMan.putVariable(rootNode, type, key, parameters.get(key));
            }
        }
    }
}

