/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.ScreenTemplatePlugin;

@Singleton
@Path(value="screens")
public class ScreenTemplateService
extends AbstractServices {
    @GET
    @Secured
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public List<Input> getInputsForScreen(@PathParam(value="id") String screenId, @Context UriInfo uriInfo, @Context ContainerRequestContext crc) {
        Map<String, Object> contextBindings = this.getContextBindings(uriInfo, crc);
        ScreenTemplatePlugin plugin = (ScreenTemplatePlugin)((Object)this.getContext().get((Object)"ScreenTemplatePlugin_Instance"));
        return plugin.getInputsForScreen(screenId, contextBindings);
    }

    private Map<String, Object> getContextBindings(UriInfo uriInfo, ContainerRequestContext crc) {
        HashMap<String, Object> contextBindings = new HashMap<String, Object>();
        Session session = (Session)crc.getProperty("session");
        if (session != null) {
            contextBindings.put("user", session.getUsername());
            contextBindings.put("role", session.getProfile().getRole());
        }
        for (String key : uriInfo.getQueryParameters().keySet()) {
            contextBindings.put(key, uriInfo.getQueryParameters().getFirst((Object)key));
        }
        return contextBindings;
    }
}

