/*
 * Decompiled with CFR 0.152.
 */
package step.functions.base.types.handler;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import step.functions.base.types.handler.BaseFunctionSchema;
import step.handlers.javahandler.Keyword;

public class BaseFunctionReflectionHelper {
    public static final String LOCALFUNCTIONCLASSES_PREFIX = "step.functions.base.defaults";

    public static Map<String, String> getLocalKeywordsWithSchemas() throws Exception {
        HashMap<String, String> keywordList = new HashMap<String, String>();
        try {
            Set methods = BaseFunctionReflectionHelper.getLocalFunctionBaseReflections().getMethodsAnnotatedWith(Keyword.class);
            for (Method method : methods) {
                String schema = "{}";
                if (BaseFunctionReflectionHelper.isImplementsInterface(method.getDeclaringClass().getGenericInterfaces(), BaseFunctionSchema.class)) {
                    BaseFunctionSchema keywordSchema = (BaseFunctionSchema)method.getDeclaringClass().newInstance();
                    Map<String, String> schemas = keywordSchema.getKeywordSchemas();
                    schema = schemas == null ? "{}" : schemas.get(method.getName());
                }
                keywordList.put(method.getName(), schema);
            }
            return keywordList;
        }
        catch (Exception e) {
            String errorMsg = "Error while looking for methods annotated with @Keyword in base classloader";
            throw new Exception(errorMsg, e);
        }
    }

    private static Reflections getLocalFunctionBaseReflections() {
        return new Reflections(LOCALFUNCTIONCLASSES_PREFIX, new Scanner[]{new MethodAnnotationsScanner()});
    }

    private static boolean isImplementsInterface(Type[] genericInterfaces, Class<BaseFunctionSchema> class1) {
        for (Type type : genericInterfaces) {
            if (!type.getTypeName().equals(class1.getName())) continue;
            return true;
        }
        return false;
    }

    public static List<String> getLocalKeywordList() throws Exception {
        ArrayList<String> keywordList = new ArrayList<String>();
        try {
            Set methods = BaseFunctionReflectionHelper.getLocalFunctionBaseReflections().getMethodsAnnotatedWith(Keyword.class);
            for (Method method : methods) {
                keywordList.add(method.getName());
            }
            return keywordList;
        }
        catch (Exception e) {
            String errorMsg = "Error while looking for methods annotated with @Keyword in base classloader";
            throw new Exception(errorMsg, e);
        }
    }

    public static Set<Class<?>> getLocalKeywordClasses() throws Exception {
        HashSet classSet = new HashSet();
        for (Method m : BaseFunctionReflectionHelper.getLocalFunctionBaseReflections().getMethodsAnnotatedWith(Keyword.class)) {
            classSet.add(m.getDeclaringClass());
        }
        return classSet;
    }

    public static List<String> getLocalKeywordClassNames() throws Exception {
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class<?> clazz : BaseFunctionReflectionHelper.getLocalKeywordClasses()) {
            classNames.add(clazz.getName());
        }
        return classNames;
    }
}

