/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.execution.ExecutionContext;
import step.core.miscellaneous.ValidationException;
import step.core.variables.SimpleStringMap;
import step.datapool.DataSet;
import step.datapool.excel.ExcelDataPool;
import step.datapool.excel.ExcelFileLookup;
import step.datapool.excel.ExcelFunctions;
import step.datapool.excel.WorkbookSet;

public class ExcelDataPoolImpl
extends DataSet<ExcelDataPool> {
    private static Logger logger = LoggerFactory.getLogger(ExcelDataPoolImpl.class);
    WorkbookSet workbookSet;
    Sheet sheet;
    int cursor;
    boolean forWrite;
    volatile boolean updated = false;
    static Pattern crossSheetPattern = Pattern.compile("^(.+?)::(.+?)$");
    private static final String SKIP_STRING = "@SKIP";

    public ExcelDataPoolImpl(ExcelDataPool configuration) {
        super((Object)configuration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        String bookName = (String)((ExcelDataPool)((Object)this.configuration)).getFile().get();
        String sheetName = (String)((ExcelDataPool)((Object)this.configuration)).getWorksheet().get();
        logger.debug("book: " + bookName + " sheet: " + sheetName);
        ExcelFileLookup excelFileLookup = new ExcelFileLookup(this.context);
        File workBookFile = excelFileLookup.lookup(bookName);
        this.forWrite = (Boolean)((ExcelDataPool)((Object)this.configuration)).getForWrite().get();
        this.workbookSet = new WorkbookSet(workBookFile, ExcelFunctions.getMaxExcelSize(), this.forWrite, true);
        Workbook workbook = this.workbookSet.getMainWorkbook();
        if (sheetName == null || sheetName.isEmpty()) {
            if (workbook.getNumberOfSheets() > 0) {
                this.sheet = workbook.getSheetAt(0);
            } else {
                if (!this.forWrite) throw new ValidationException("The workbook " + workBookFile.getName() + " contains no sheet");
                this.sheet = workbook.createSheet();
            }
        } else {
            this.sheet = workbook.getSheet(sheetName);
            if (this.sheet == null) {
                if (!this.forWrite) throw new ValidationException("The sheet " + sheetName + " doesn't exist in the workbook " + workBookFile.getName());
                this.sheet = workbook.createSheet(sheetName);
            }
        }
        this.resetCursor();
    }

    public void reset() {
        this.resetCursor();
    }

    private void resetCursor() {
        this.cursor = (Boolean)((ExcelDataPool)((Object)this.configuration)).getHeaders().get() != false ? 0 : -1;
    }

    private int mapHeaderToCellNum(Sheet sheet, String header, boolean createHeaderIfNotExisting) {
        if (((Boolean)((ExcelDataPool)((Object)this.configuration)).getHeaders().get()).booleanValue()) {
            Row row = sheet.getRow(0);
            if (row != null) {
                for (Cell cell : row) {
                    String key = ExcelFunctions.getCellValueAsString(cell, this.workbookSet.getMainFormulaEvaluator());
                    if (key == null || !key.equals(header)) continue;
                    return cell.getColumnIndex();
                }
            } else if (createHeaderIfNotExisting) {
                sheet.createRow(0);
            } else {
                throw new ValidationException("The sheet " + sheet.getSheetName() + " contains no headers");
            }
            if (createHeaderIfNotExisting) {
                return this.addHeader(sheet, header);
            }
            throw new ValidationException("The column " + header + " doesn't exist in sheet " + sheet.getSheetName());
        }
        return CellReference.convertColStringToIndex((String)header);
    }

    private int addHeader(Sheet sheet, String header) {
        if (((Boolean)((ExcelDataPool)((Object)this.configuration)).getHeaders().get()).booleanValue()) {
            Row row = sheet.getRow(0);
            Cell cell = row.createCell(Math.max(0, row.getLastCellNum()));
            cell.setCellValue(header);
            this.updated = true;
            return cell.getColumnIndex();
        }
        throw new RuntimeException("Unable to create header for excel configured not to use headers.");
    }

    private List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        Row row = this.sheet.getRow(0);
        for (Cell cell : row) {
            String key = ExcelFunctions.getCellValueAsString(cell, this.workbookSet.getMainFormulaEvaluator());
            headers.add(key);
        }
        return headers;
    }

    public Object next_() {
        block1: {
            block2: {
                block3: {
                    String value;
                    do {
                        ++this.cursor;
                        if (this.cursor > this.sheet.getLastRowNum()) break block1;
                        Cell cell = this.sheet.getRow(this.cursor).getCell(0);
                        if (cell == null) break block2;
                        value = ExcelFunctions.getCellValueAsString(cell, this.workbookSet.getMainFormulaEvaluator());
                        if (value == null || value.isEmpty()) break block3;
                    } while (value.equals(SKIP_STRING));
                    return new RowWrapper(this.cursor);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void save() {
        if (this.updated) {
            try {
                this.workbookSet.save();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing file " + this.workbookSet.getMainWorkbookFile().getAbsolutePath(), e);
            }
        }
    }

    public void close() {
        if (this.workbookSet != null) {
            this.workbookSet.close();
        }
        this.sheet = null;
    }

    private Cell getCellByID(int cursor, String name) {
        Row row;
        Sheet sheet;
        String colName;
        Matcher matcher = crossSheetPattern.matcher(name);
        if (matcher.find()) {
            String sheetName = matcher.group(1);
            colName = matcher.group(2);
            sheet = this.workbookSet.getMainWorkbook().getSheet(sheetName);
            if (sheet == null) {
                throw new ValidationException("The sheet " + sheetName + " doesn't exist in the workbook " + this.workbookSet.getMainWorkbookFile().getName());
            }
        } else {
            sheet = this.sheet;
            colName = name;
        }
        if ((row = sheet.getRow(cursor)) == null) {
            row = sheet.createRow(cursor);
        }
        int cellNum = this.mapHeaderToCellNum(sheet, colName, false);
        Cell cell = row.getCell(cellNum, Row.CREATE_NULL_AS_BLANK);
        return cell;
    }

    public void addRow(Object rowInput_) {
        if (rowInput_ instanceof Map) {
            Row row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            Map rowInput = (Map)rowInput_;
            for (Object keyObject : rowInput.keySet()) {
                if (!(keyObject instanceof String)) continue;
                int cellNum = this.mapHeaderToCellNum(this.sheet, (String)keyObject, true);
                Cell cell = row.createCell(cellNum);
                cell.setCellValue(rowInput.get(keyObject).toString());
                this.updated = true;
            }
        } else {
            throw new RuntimeException("Add row not implemented for object of type '" + rowInput_.getClass());
        }
    }

    public void setContext(ExecutionContext executionContext) {
        this.context = executionContext;
    }

    private class RowWrapper
    extends SimpleStringMap {
        private final int cursor;

        public RowWrapper(int cursor) {
            this.cursor = cursor;
        }

        public Set<String> keySet() {
            HashSet<String> headers = new HashSet<String>(ExcelDataPoolImpl.this.getHeaders());
            return headers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String get(String key) {
            WorkbookSet workbookSet = ExcelDataPoolImpl.this.workbookSet;
            synchronized (workbookSet) {
                Cell cell = ExcelDataPoolImpl.this.getCellByID(this.cursor, key);
                return ExcelFunctions.getCellValueAsString(cell, ExcelDataPoolImpl.this.workbookSet.getMainFormulaEvaluator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String put(String key, String value) {
            WorkbookSet workbookSet = ExcelDataPoolImpl.this.workbookSet;
            synchronized (workbookSet) {
                Cell cell = ExcelDataPoolImpl.this.getCellByID(this.cursor, key);
                if (cell != null) {
                    ExcelDataPoolImpl.this.updated = true;
                    cell.setCellValue(value);
                    ExcelDataPoolImpl.this.workbookSet.getMainFormulaEvaluator().notifyUpdateCell(cell);
                }
                return value;
            }
        }

        public int size() {
            int tableWidth = ExcelDataPoolImpl.this.getHeaders().size();
            int nonNullCells = 0;
            for (int i = 0; i < tableWidth; ++i) {
                String value;
                Cell cell = ExcelDataPoolImpl.this.sheet.getRow(this.cursor).getCell(i);
                if (cell == null || (value = ExcelFunctions.getCellValueAsString(cell, ExcelDataPoolImpl.this.workbookSet.getMainFormulaEvaluator())) == null || value.isEmpty()) continue;
                ++nonNullCells;
            }
            return nonNullCells;
        }

        public boolean isEmpty() {
            return this.size() < 1;
        }
    }
}

