/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.util.CellReference;

public class CellIndexParser {
    private static final Pattern CELL_INDEX_PATTERN = Pattern.compile("([A-Z]+)::([0-9]+)");
    private static final Pattern CELL_IND_PATTERN_TOLERANT = Pattern.compile("([A-Z]+)[::]?([0-9]+)");

    private static String normalizeCellIndex(String cellIndex) {
        Matcher cellIndexMatcher;
        String norm = cellIndex.trim();
        if ((norm = norm.toUpperCase()).endsWith(".0")) {
            norm = norm.replace(".0", "");
        }
        if ((cellIndexMatcher = CELL_IND_PATTERN_TOLERANT.matcher(norm)).matches()) {
            String col = cellIndexMatcher.group(1);
            String row = cellIndexMatcher.group(2);
            norm = col + "::" + row;
        }
        return norm;
    }

    public static CellIndex parse(String cellIndex) {
        Matcher cellIndexMatcher = CELL_INDEX_PATTERN.matcher(cellIndex = CellIndexParser.normalizeCellIndex(cellIndex));
        if (cellIndexMatcher.matches()) {
            Integer rowNum;
            Integer n = rowNum = Integer.decode(cellIndexMatcher.group(2));
            Integer n2 = rowNum = Integer.valueOf(rowNum - 1);
            Integer column = CellReference.convertColStringToIndex((String)cellIndexMatcher.group(1));
            return new CellIndex(column, rowNum);
        }
        throw new RuntimeException("Invalid cell index: '" + cellIndex + "'. Valid format are 'A1' or 'A::1'");
    }

    public static class CellIndex {
        int colNum;
        int rowNum;

        public CellIndex(int colIndex, int rowIndex) {
            this.colNum = colIndex;
            this.rowNum = rowIndex;
        }

        public int getColNum() {
            return this.colNum;
        }

        public int getRowNum() {
            return this.rowNum;
        }
    }
}

