/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.file;

import java.io.File;
import junit.framework.Assert;
import org.junit.Test;
import step.commons.helpers.FileHelper;
import step.core.dynamicbeans.DynamicValue;
import step.core.execution.ContextBuilder;
import step.core.execution.ExecutionContext;
import step.datapool.DataPoolConfiguration;
import step.datapool.DataPoolFactory;
import step.datapool.DataSet;
import step.datapool.file.FileDataPool;

public class FlatFileReaderDataPoolTest {
    @Test
    public void testFlatFileReaderDataPool() {
        DataSet<?> pool = this.getDataPool("File.txt", "file");
        Assert.assertEquals((Object)"Line 1", (Object)pool.next().getValue());
        pool.close();
    }

    protected DataSet<?> getDataPool(String file, String type) {
        FileDataPool conf = this.getDataSourceConf(file);
        DataSet pool = DataPoolFactory.getDataPool((String)type, (DataPoolConfiguration)conf, (ExecutionContext)ContextBuilder.createLocalExecutionContext());
        pool.init();
        return pool;
    }

    private FileDataPool getDataSourceConf(String filename) {
        File file = FileHelper.getClassLoaderResource(this.getClass(), (String)filename);
        FileDataPool conf = new FileDataPool();
        conf.setFile(new DynamicValue((Object)file.getAbsolutePath()));
        return conf;
    }
}

