/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import step.commons.helpers.FileHelper;
import step.datapool.excel.ExcelFunctions;

public class ExcelFunctionsTest {
    @Before
    public void setUp() {
        Locale.setDefault(new Locale("de"));
    }

    @Test
    public void testRead() {
        Assert.assertEquals((String)"Values", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"Foglio1", (String)"A::1"));
    }

    @Test
    public void testCellTypes() {
        Assert.assertEquals((String)"01.01.2016", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B1"));
        Assert.assertEquals((String)"12:00:00", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B2"));
        Assert.assertEquals((String)"100", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B3"));
        Assert.assertEquals((String)"100.1", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B4"));
        Assert.assertEquals((String)Boolean.toString(true), (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B5"));
        Assert.assertEquals((String)"String with\nnew line", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B6"));
        Assert.assertEquals((String)"0.22", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B7"));
        Assert.assertEquals((String)"0.016", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B8"));
        Assert.assertEquals((String)"0.01677777777777", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B9"));
        Assert.assertEquals((String)"0.01677777777778", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"CellTypes", (String)"B10"));
    }

    @Test
    public void testErrors() {
        this.assertException(() -> ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"Errors", (String)"B1"), "Error while evaluating cell B1 from sheet Errors:");
        this.assertException(() -> ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"Errors", (String)"B2"), "Error while evaluating cell B2 from sheet Errors:");
    }

    @Test
    public void testDates() {
        Assert.assertEquals((String)"01.01.2000", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"Dates", (String)"A1"));
        Assert.assertEquals((String)"12:02:00", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"Dates", (String)"A2"));
    }

    @Test
    public void testTEXT() {
        Assert.assertEquals((String)"01.01.2016", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"TEXT", (String)"B1"));
        Assert.assertEquals((String)"01/01/2016", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"TEXT", (String)"B2"));
        Assert.assertEquals((String)"2016-01-01", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"TEXT", (String)"B3"));
        Assert.assertEquals((String)"20160101", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"TEXT", (String)"B4"));
        Assert.assertEquals((String)"01/01/2016", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"TEXT", (String)"B5"));
        Assert.assertEquals((String)"8 Februar 2016", (String)ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("Excel1.xlsx"), (String)"TEXT", (String)"B6"));
    }

    @Test
    public void testWriteExcel() throws IOException {
        String value = UUID.randomUUID().toString();
        ExcelFunctions.putCell((String)ExcelFunctionsTest.getResourceFile("WriteTest.xlsx").getAbsolutePath(), (String)"Foglio1", (String)"A::1", (String)value, null);
        String actual = ExcelFunctions.getCell((File)ExcelFunctionsTest.getResourceFile("WriteTest.xlsx"), (String)"Foglio1", (String)"A::1");
        Assert.assertEquals((String)value, (String)actual);
    }

    @Test
    public void testCreateExcel() throws IOException {
        File file = new File("CreateExcelTest.xlsx");
        if (file.exists()) {
            file.delete();
        }
        file.deleteOnExit();
        String value = UUID.randomUUID().toString();
        ExcelFunctions.putCell((String)file.getAbsolutePath(), (String)"Foglio1", (String)"A1", (String)value, null);
        String actual = ExcelFunctions.getCell((String)file.getAbsolutePath(), (String)"Foglio1", (String)"A1");
        Assert.assertEquals((String)value, (String)actual);
    }

    public static File getResourceFile(String filename) {
        return FileHelper.getClassLoaderResource(ExcelFunctionsTest.class, (String)filename);
    }

    public void assertException(Runnable r, String msg) {
        Exception expected = null;
        try {
            r.run();
        }
        catch (Exception e) {
            expected = e;
        }
        Assert.assertNotNull((Object)expected);
        Assert.assertTrue((boolean)expected.getMessage().contains(msg));
    }
}

