/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.gsheet;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.DriveScopes;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.SheetsScopes;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import step.attachments.FileResolver;
import step.core.variables.SimpleStringMap;
import step.datapool.DataSet;
import step.datapool.gsheet.GoogleSheetv4DataPoolConfiguration;

public class GoogleSheetv4DataPool
extends DataSet<GoogleSheetv4DataPoolConfiguration> {
    FileResolver fileResolver;
    private String saKey;
    private String fileId;
    private String tabName;
    List<List<Object>> datapool;
    List<String> headers;
    int cursor;
    Sheets service = null;

    public GoogleSheetv4DataPool(GoogleSheetv4DataPoolConfiguration configuration) {
        super((Object)configuration);
        this.saKey = (String)configuration.getServiceAccountKey().get();
        this.fileId = (String)configuration.getFileId().get();
        this.tabName = (String)configuration.getTabName().get();
    }

    public void init() {
        this.fileResolver = new FileResolver(this.context.getAttachmentManager());
        this.createDatapool(this.saKey, this.fileId, this.tabName);
        this.createHeaders();
        this.cursor = 1;
    }

    private void createHeaders() {
        this.headers = new LinkedList<String>();
        for (Object o : this.datapool.get(0)) {
            this.headers.add((String)o);
        }
    }

    private int getIndexForHeader(String header) {
        return this.headers.indexOf(header);
    }

    public void reset() {
        this.init();
    }

    public void close() {
    }

    public Object next_() {
        if (this.cursor >= this.datapool.size()) {
            return null;
        }
        RowWrapper row = new RowWrapper(this.cursor);
        ++this.cursor;
        return row;
    }

    public void addRow(Object row) {
        throw new RuntimeException("Not implemented");
    }

    public void createDatapool(String saKey, String fileId, String tabName) {
        try {
            this.service = this.buildService(this.getCredential(saKey));
            this.datapool = this.getValuesForRange(fileId, tabName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleCredential getCredential(String saKey) throws Exception {
        HashSet all = new HashSet();
        all.addAll(SheetsScopes.all());
        all.addAll(DriveScopes.all());
        GoogleCredential gCred = null;
        try (FileInputStream keyFileIS = null;){
            keyFileIS = new FileInputStream(this.fileResolver.resolve(saKey));
            gCred = GoogleCredential.fromStream((InputStream)keyFileIS).createScoped(all);
        }
        return gCred;
    }

    public Sheets buildService(GoogleCredential credential) throws IOException, GeneralSecurityException {
        return new Sheets.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName("Sheets API Snippets").build();
    }

    public List<List<Object>> getValuesForRange(String spreadsheetId, String range) throws IOException {
        ValueRange result = (ValueRange)this.service.spreadsheets().values().get(spreadsheetId, range).execute();
        return result.getValues();
    }

    private class RowWrapper
    extends SimpleStringMap {
        private int cursor;

        public RowWrapper(int cursor) {
            this.cursor = cursor;
        }

        public int size() {
            return GoogleSheetv4DataPool.this.datapool.get(this.cursor).size();
        }

        public boolean isEmpty() {
            return GoogleSheetv4DataPool.this.datapool.get(this.cursor).isEmpty();
        }

        public String get(String key) {
            if (GoogleSheetv4DataPool.this.getIndexForHeader(key) < 0) {
                throw new RuntimeException("Column unknown:" + key);
            }
            return (String)GoogleSheetv4DataPool.this.datapool.get(this.cursor).get(GoogleSheetv4DataPool.this.getIndexForHeader(key));
        }

        public String put(String key, String value) {
            throw new RuntimeException("Not implemented.");
        }

        public Set<String> keySet() {
            return new HashSet<String>(GoogleSheetv4DataPool.this.headers);
        }
    }
}

