/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkbookFile
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(WorkbookFile.class);
    private File file;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Workbook workbook;
    private static Pattern FILENAME_PATTERN = Pattern.compile("(.*)\\.(.+?)$");
    private static String DATE_FORMAT = "yyyyMMddhhmmss";

    public WorkbookFile() {
    }

    public WorkbookFile(File mainWorkbook, Integer maxWorkbookSize, boolean createIfNotExists) {
        this.open(mainWorkbook, maxWorkbookSize, createIfNotExists, false);
    }

    public WorkbookFile(File mainWorkbook, Integer maxWorkbookSize, boolean createIfNotExists, boolean forUpdate) {
        try {
            this.open(mainWorkbook, maxWorkbookSize, createIfNotExists, forUpdate);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private void create(File mainWorkbook) {
        this.file = mainWorkbook;
        this.workbook = new XSSFWorkbook();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void open(File mainWorkbook, Integer maxWorkbookSize, boolean createIfNotExists, boolean forUpdate) {
        this.file = mainWorkbook;
        if (mainWorkbook.exists()) {
            if (!mainWorkbook.canRead()) throw new RuntimeException("The workbook '" + mainWorkbook.getName() + "' cannot be read.");
            if (forUpdate && this.isFileIsOpenedByAnotherProcess()) {
                throw new RuntimeException("The file '" + this.file.getAbsolutePath() + "' is not writable. It might already be opened by another process.");
            }
            this.checkFileSize(mainWorkbook, maxWorkbookSize);
            try {
                this.inputStream = new BufferedInputStream(new FileInputStream(mainWorkbook));
                this.workbook = WorkbookFactory.create((InputStream)this.inputStream);
                return;
            }
            catch (IOException | EncryptedDocumentException | InvalidFormatException e) {
                throw new RuntimeException("Error while opening workbook '" + mainWorkbook.getName() + "'", e);
            }
        } else {
            if (!createIfNotExists) throw new RuntimeException("The workbook '" + mainWorkbook.getName() + "' doesn't exist.");
            this.create(mainWorkbook);
        }
    }

    void checkFileSize(File file, Integer maxWorkbookSize) {
        if (maxWorkbookSize != null && file.length() > (long)maxWorkbookSize.intValue()) {
            throw new RuntimeException("The size of the workbook '" + file.getName() + "' exceeds the max size " + maxWorkbookSize + "bytes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.workbook.setForceFormulaRecalculation(true);
        try {
            this.closeInputStream();
            try {
                this.openOutputStream(this.file);
            }
            catch (IOException e) {
                File backupFile = this.createBackupFile();
                logger.info("Unable to open workbook " + this.file.getAbsolutePath() + ". Creating backup file." + backupFile.getAbsolutePath());
                try {
                    this.openOutputStream(backupFile);
                }
                catch (IOException e2) {
                    throw new RuntimeException("Unable to open backup workbook " + this.file.getAbsolutePath());
                }
            }
            this.writeWorkbookToOutputStream();
        }
        catch (IOException e) {
            logger.error("Error saving workbook " + this.file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            this.closeOutputStream();
        }
    }

    private void closeOutputStream() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("Error while closing outputstream", (Throwable)e);
        }
        finally {
            this.outputStream = null;
        }
    }

    private void closeInputStream() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("Error while closing inputstream", (Throwable)e);
        }
        finally {
            this.inputStream = null;
        }
    }

    private File createBackupFile() {
        Matcher m = FILENAME_PATTERN.matcher(this.file.getAbsolutePath());
        if (m.find()) {
            String filename = m.group(1);
            String extension = m.group(2);
            SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT);
            String backupFilename = filename + "_" + f.format(new Date()) + "." + extension;
            return new File(backupFilename);
        }
        throw new RuntimeException("Unable to create backup file. The path " + this.file.getAbsolutePath() + " doesn't match the expected pattern");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFileIsOpenedByAnotherProcess() {
        try (FileOutputStream outputStream = new FileOutputStream(this.file, true);){
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    private void openOutputStream(File file) throws FileNotFoundException {
        this.outputStream = new BufferedOutputStream(new FileOutputStream(file));
    }

    private void writeWorkbookToOutputStream() throws IOException {
        this.workbook.write(this.outputStream);
    }

    @Override
    public void close() {
        this.closeInputStream();
        this.closeOutputStream();
        try {
            if (this.workbook != null) {
                this.workbook.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }
}

