/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.file;

import java.io.File;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import step.commons.helpers.FileHelper;
import step.core.dynamicbeans.DynamicValue;
import step.core.execution.ContextBuilder;
import step.core.execution.ExecutionContext;
import step.datapool.DataPoolConfiguration;
import step.datapool.DataPoolFactory;
import step.datapool.DataSet;
import step.datapool.file.DirectoryDataPool;
import step.datapool.file.FileDataPoolImpl;

public class DirectoryDataPoolTest {
    private DataSet<?> pool;
    private File file;

    @Before
    public void before() {
        this.file = FileHelper.getClassLoaderResource(this.getClass(), (String)"folder");
        DirectoryDataPool conf = new DirectoryDataPool();
        conf.setFolder(new DynamicValue((Object)this.file.getAbsolutePath()));
        this.pool = DataPoolFactory.getDataPool((String)"folder", (DataPoolConfiguration)conf, (ExecutionContext)ContextBuilder.createLocalExecutionContext());
        this.pool.init();
    }

    @After
    public void after() {
        this.pool.close();
    }

    @Test
    public void testDirectoryDataPoolTestToString() {
        Assert.assertTrue((boolean)this.pool.next().getValue().toString().contains("File.txt"));
    }

    @Test
    public void testDirectoryDataPoolTestGetName() {
        Assert.assertEquals((String)"File", (String)((FileDataPoolImpl.ExtendedFile)this.pool.next().getValue()).getNameWithoutExtension());
        Assert.assertEquals((String)"File2.txt", (String)((FileDataPoolImpl.ExtendedFile)this.pool.next().getValue()).getName());
    }

    @Test
    public void testDirectoryDataPoolTestGetPath() {
        Assert.assertEquals((String)this.file.getAbsolutePath(), (String)((FileDataPoolImpl.ExtendedFile)this.pool.next().getValue()).getPath());
    }
}

