/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.Check;
import step.artefacts.CheckArtefact;
import step.artefacts.TestSet;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;
import step.core.plans.runner.DefaultPlanRunner;

public class TestSetHandlerTest
extends AbstractArtefactHandlerTest {
    public void testParallel() throws Exception {
        HashSet<Long> threadIdSet = new HashSet<Long>();
        this.execute(threadIdSet, "10", "DummyName{childID}");
        Assert.assertEquals((String)"Ensure that the TestSetHandler runs the child artefacts in parallel", (int)10, (int)threadIdSet.size());
    }

    public void testSequential() throws Exception {
        HashSet<Long> threadIdSet = new HashSet<Long>();
        this.execute(threadIdSet, "1", "DummyName{childID}");
        Assert.assertEquals((String)"Ensure that the TestSetHandler runs the child artefacts sequentially", (int)1, (int)threadIdSet.size());
    }

    @Test
    public void testStatusReportingFailed() throws Exception {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new TestSet()).add((AbstractArtefact)this.passedCheck()).add((AbstractArtefact)this.failedCheck()).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        StringWriter writer = new StringWriter();
        runner.run(plan).printTree((Writer)writer);
        Assert.assertTrue((boolean)writer.toString().startsWith("TestSet:" + ReportNodeStatus.FAILED));
    }

    @Test
    public void testStatusReportingPassed() throws Exception {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new TestSet()).add((AbstractArtefact)this.passedCheck()).add((AbstractArtefact)this.passedCheck()).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        StringWriter writer = new StringWriter();
        runner.run(plan).printTree((Writer)writer);
        Assert.assertTrue((boolean)writer.toString().startsWith("TestSet:" + ReportNodeStatus.PASSED));
    }

    @Test
    public void testStatusReportingError() throws Exception {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new TestSet()).add((AbstractArtefact)this.passedCheck()).add((AbstractArtefact)this.errorCheck()).add((AbstractArtefact)this.passedCheck()).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        StringWriter writer = new StringWriter();
        runner.run(plan).printTree((Writer)writer);
        Assert.assertTrue((boolean)writer.toString().startsWith("TestSet:" + ReportNodeStatus.TECHNICAL_ERROR));
    }

    private Check passedCheck() {
        Check passedCheck = new Check();
        passedCheck.setExpression(new DynamicValue((Object)true));
        return passedCheck;
    }

    private Check failedCheck() {
        Check failedCheck = new Check();
        failedCheck.setExpression(new DynamicValue((Object)false));
        return failedCheck;
    }

    private Check errorCheck() {
        Check errorCheck = new Check();
        return errorCheck;
    }

    private void execute(HashSet<Long> threadIdSet, String tecExecutionThreads, String childNamePattern) {
        this.setupContext();
        this.context.getVariablesManager().putVariable(this.context.getReport(), "tec.execution.threads", (Object)tecExecutionThreads);
        this.context.getVariablesManager().getVariable("var");
        TestSet set = new TestSet();
        this.add(set);
        int nChilds = 20;
        for (int j = 0; j < nChilds; ++j) {
            this.addAsChildOf(new CheckArtefact(c -> {
                HashSet hashSet = threadIdSet;
                synchronized (hashSet) {
                    threadIdSet.add(Thread.currentThread().getId());
                }
                this.context.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED);
            }), (AbstractArtefact)set);
        }
        this.createSkeleton((AbstractArtefact)set);
        this.execute((AbstractArtefact)set);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        Assert.assertEquals((int)nChilds, (int)this.getChildren(child).size());
        for (ReportNode node : this.getChildren(child)) {
            Assert.assertEquals((Object)node.getStatus(), (Object)ReportNodeStatus.PASSED);
        }
    }
}

