/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import step.artefacts.CheckArtefact;
import step.artefacts.ForBlock;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.artefacts.reports.ForBlockReportNode;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;
import step.core.plans.runner.DefaultPlanRunner;
import step.datapool.DataPoolConfiguration;
import step.datapool.sequence.IntSequenceDataPool;

public class ForHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void testSuccess() {
        this.setupContext();
        this.context.getVariablesManager().putVariable(this.context.getReport(), "var", (Object)"val1");
        ForBlock f = this.add(new ForBlock());
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setEnd(new DynamicValue((Object)3));
        conf.setInc(new DynamicValue((Object)2));
        f.setDataSource((DataPoolConfiguration)conf);
        f.setItem(new DynamicValue((Object)"item"));
        AtomicInteger i = new AtomicInteger(1);
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(c -> {
            this.context.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED);
            junit.framework.Assert.assertEquals((int)i.get(), (int)this.context.getVariablesManager().getVariableAsInteger("item"));
            i.addAndGet(2);
        }), (AbstractArtefact)f);
        this.execute((AbstractArtefact)f);
        ForBlockReportNode child = (ForBlockReportNode)this.getFirstReportNode();
        junit.framework.Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        junit.framework.Assert.assertEquals((int)2, (int)child.getCount());
        junit.framework.Assert.assertEquals((int)0, (int)child.getErrorCount());
        junit.framework.Assert.assertEquals((int)this.getChildren((ReportNode)child).size(), (int)2);
        for (ReportNode node : this.getChildren((ReportNode)child)) {
            junit.framework.Assert.assertEquals((Object)node.getStatus(), (Object)ReportNodeStatus.PASSED);
            junit.framework.Assert.assertEquals((int)this.getChildren(node).size(), (int)1);
            junit.framework.Assert.assertEquals((Object)check1.getId(), (Object)this.getChildren(node).get(0).getArtefactID());
        }
    }

    @Test
    public void testBreak() {
        this.setupContext();
        ForBlock f = this.add(new ForBlock());
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setEnd(new DynamicValue((Object)10));
        f.setDataSource((DataPoolConfiguration)conf);
        AtomicInteger i = new AtomicInteger(1);
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(c -> {
            if (i.get() == 2) {
                this.context.getVariablesManager().updateVariable("break", (Object)"true");
            }
            i.addAndGet(1);
            this.context.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED);
        }), (AbstractArtefact)f);
        this.execute((AbstractArtefact)f);
        ForBlockReportNode child = (ForBlockReportNode)this.getFirstReportNode();
        junit.framework.Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        junit.framework.Assert.assertEquals((int)2, (int)child.getCount());
        junit.framework.Assert.assertEquals((int)0, (int)child.getErrorCount());
    }

    @Test
    public void testMaxFailedCount() {
        this.setupContext();
        ForBlock f = this.add(new ForBlock());
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setEnd(new DynamicValue((Object)10));
        f.setDataSource((DataPoolConfiguration)conf);
        f.setMaxFailedLoops(new DynamicValue((Object)2));
        AtomicInteger i = new AtomicInteger(1);
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(c -> this.context.getCurrentReportNode().setStatus(ReportNodeStatus.FAILED)), (AbstractArtefact)f);
        this.execute((AbstractArtefact)f);
        ForBlockReportNode child = (ForBlockReportNode)this.getFirstReportNode();
        junit.framework.Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.FAILED);
        junit.framework.Assert.assertEquals((int)2, (int)child.getCount());
        junit.framework.Assert.assertEquals((int)2, (int)child.getErrorCount());
    }

    @Test
    public void testTechnicalError() throws IOException, TimeoutException, InterruptedException {
        ForBlock forBlock = new ForBlock();
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setStart(new DynamicValue((Object)1));
        conf.setEnd(new DynamicValue((Object)2));
        forBlock.setDataSource((DataPoolConfiguration)conf);
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)forBlock).add((AbstractArtefact)new CheckArtefact(c -> c.getCurrentReportNode().setStatus(ReportNodeStatus.TECHNICAL_ERROR))).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        runner.run(plan).waitForExecutionToTerminate().visitReportTree(e -> {
            if (e.getParentNode() == null) {
                Assert.assertEquals(ForBlockReportNode.class, e.getNode().getClass());
                Assert.assertEquals((Object)ReportNodeStatus.TECHNICAL_ERROR, (Object)e.getNode().getStatus());
            }
        });
    }
}

