/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import step.artefacts.AbstractForBlock;
import step.artefacts.Sequence;
import step.artefacts.handlers.AtomicReportNodeStatusComposer;
import step.artefacts.reports.ForBlockReportNode;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.datapool.DataPoolFactory;
import step.datapool.DataPoolRow;
import step.datapool.DataSet;

public class ForBlockHandler
extends ArtefactHandler<AbstractForBlock, ForBlockReportNode> {
    private static final String BREAK_VARIABLE = "break";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReportSkeleton_(ForBlockReportNode node, AbstractForBlock testArtefact) {
        List selectedChildren = this.getChildren(testArtefact);
        try (DataSet<?> dataSet = null;){
            dataSet = DataPoolFactory.getDataPool(testArtefact.getDataSourceType(), testArtefact.getDataSource(), this.context);
            dataSet.init();
            DataPoolRow nextValue = null;
            int rowCount = 0;
            while ((nextValue = dataSet.next()) != null) {
                if (this.context.isInterrupted()) {
                    break;
                }
                HashMap<Object, Object> newVariable = new HashMap<Object, Object>();
                newVariable.put(testArtefact.getItem().get(), nextValue.getValue());
                ArtefactAccessor artefactAccessor = this.context.getArtefactAccessor();
                Sequence iterationTestCase = (Sequence)artefactAccessor.createWorkArtefact(Sequence.class, (AbstractArtefact)testArtefact, "Iteration_" + ++rowCount);
                for (AbstractArtefact child : selectedChildren) {
                    iterationTestCase.addChild(child.getId());
                }
                ForBlockHandler.delegateCreateReportSkeleton((ExecutionContext)this.context, (AbstractArtefact)iterationTestCase, (ReportNode)node, newVariable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute_(ForBlockReportNode node, AbstractForBlock testArtefact) {
        DataSet<?> dataSet = null;
        try {
            List selectedChildren = this.getChildren(testArtefact);
            dataSet = DataPoolFactory.getDataPool(testArtefact.getDataSourceType(), testArtefact.getDataSource(), this.context);
            dataSet.init();
            this.context.getVariablesManager().putVariable((ReportNode)node, BREAK_VARIABLE, (Object)"false");
            AtomicInteger failedLoopsCounter = new AtomicInteger();
            AtomicInteger loopsCounter = new AtomicInteger();
            AtomicReportNodeStatusComposer reportNodeStatusComposer = new AtomicReportNodeStatusComposer(ReportNodeStatus.NORUN);
            IterationRunnable iterationRunnable = new IterationRunnable(testArtefact, selectedChildren, node, dataSet, failedLoopsCounter, loopsCounter, reportNodeStatusComposer);
            Integer numberOfThreads = (Integer)testArtefact.getThreads().get();
            if (numberOfThreads > 1) {
                ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
                for (int i = 0; i < numberOfThreads; ++i) {
                    executor.submit(iterationRunnable);
                }
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            } else {
                iterationRunnable.run();
            }
            node.setErrorCount(failedLoopsCounter.get());
            node.setCount(loopsCounter.get());
            node.setStatus(reportNodeStatusComposer.getParentStatus());
        }
        catch (Exception e) {
            this.failWithException(node, e);
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.save();
                }
                finally {
                    dataSet.close();
                }
            }
        }
    }

    public ForBlockReportNode createReportNode_(ReportNode parentNode, AbstractForBlock testArtefact) {
        return new ForBlockReportNode();
    }

    private class IterationRunnable
    implements Runnable {
        private final DataSet<?> dataSet;
        private final AtomicInteger failedLoops;
        private final AtomicReportNodeStatusComposer reportNodeStatusComposer;
        private final ReportNode node;
        private final AbstractForBlock testArtefact;
        private final AtomicInteger loopsCounter;
        private final List<AbstractArtefact> selectedChildren;

        public IterationRunnable(AbstractForBlock testArtefact, List<AbstractArtefact> selectedChildren, ReportNode node, DataSet<?> dataSet, AtomicInteger failedLoops, AtomicInteger loopsCounter, AtomicReportNodeStatusComposer reportNodeStatusComposer) {
            this.testArtefact = testArtefact;
            this.node = node;
            this.dataSet = dataSet;
            this.failedLoops = failedLoops;
            this.reportNodeStatusComposer = reportNodeStatusComposer;
            this.loopsCounter = loopsCounter;
            this.selectedChildren = selectedChildren;
        }

        @Override
        public void run() {
            ForBlockHandler.this.context.associateThread();
            try {
                DataPoolRow nextValue = null;
                while ((nextValue = this.dataSet.next()) != null) {
                    boolean forInterrupted = Boolean.parseBoolean((String)ForBlockHandler.this.context.getVariablesManager().getVariable(this.node, ForBlockHandler.BREAK_VARIABLE, false));
                    Integer maxFailedLoops = (Integer)this.testArtefact.getMaxFailedLoops().get();
                    if (!(forInterrupted || ForBlockHandler.this.context.isInterrupted() || maxFailedLoops != null && this.failedLoops.get() >= maxFailedLoops)) {
                        int i = this.loopsCounter.incrementAndGet();
                        HashMap<Object, Object> newVariable = new HashMap<Object, Object>();
                        newVariable.put(this.testArtefact.getItem().get(), nextValue.getValue());
                        ArtefactAccessor artefactAccessor = ForBlockHandler.this.context.getArtefactAccessor();
                        Sequence iterationTestCase = (Sequence)artefactAccessor.createWorkArtefact(Sequence.class, (AbstractArtefact)this.testArtefact, "Iteration" + i);
                        for (AbstractArtefact child : this.selectedChildren) {
                            iterationTestCase.addChild(child.getId());
                        }
                        ReportNode iterationReportNode = ArtefactHandler.delegateExecute((ExecutionContext)ForBlockHandler.this.context, (AbstractArtefact)iterationTestCase, (ReportNode)this.node, newVariable);
                        this.reportNodeStatusComposer.addStatusAndRecompose(iterationReportNode.getStatus());
                        if (iterationReportNode.getStatus() != ReportNodeStatus.TECHNICAL_ERROR && iterationReportNode.getStatus() != ReportNodeStatus.FAILED) continue;
                        this.failedLoops.incrementAndGet();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                ForBlockHandler.this.failWithException(this.node, e);
            }
        }
    }
}

