/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.Check;
import step.artefacts.ThreadGroup;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;
import step.core.plans.runner.DefaultPlanRunner;

public class ThreadGroupHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void testStatusReportingFailed() throws Exception {
        ThreadGroup artefact = new ThreadGroup();
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)artefact).add((AbstractArtefact)this.passedCheck()).add((AbstractArtefact)this.failedCheck()).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        StringWriter writer = new StringWriter();
        runner.run(plan).printTree((Writer)writer);
        Assert.assertTrue((boolean)writer.toString().startsWith("ThreadGroup:" + ReportNodeStatus.FAILED));
    }

    @Test
    public void testStatusReportingPassed() throws Exception {
        ThreadGroup artefact = new ThreadGroup();
        artefact.getIterations().setValue((Object)3);
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)artefact).add((AbstractArtefact)this.passedCheck()).add((AbstractArtefact)this.passedCheck()).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        StringWriter writer = new StringWriter();
        runner.run(plan).printTree((Writer)writer);
        Assert.assertEquals((String)"ThreadGroup:PASSED:\n Group_0_Iteration_0:PASSED:\n  Check:PASSED:\n  Check:PASSED:\n Group_0_Iteration_1:PASSED:\n  Check:PASSED:\n  Check:PASSED:\n Group_0_Iteration_2:PASSED:\n  Check:PASSED:\n  Check:PASSED:\n", (String)writer.toString());
    }

    @Test
    public void testStatusReportingError() throws Exception {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new ThreadGroup()).add((AbstractArtefact)this.passedCheck()).add((AbstractArtefact)this.errorCheck()).add((AbstractArtefact)this.passedCheck()).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        StringWriter writer = new StringWriter();
        runner.run(plan).printTree((Writer)writer);
        Assert.assertTrue((boolean)writer.toString().startsWith("ThreadGroup:" + ReportNodeStatus.TECHNICAL_ERROR));
    }

    private Check passedCheck() {
        Check passedCheck = new Check();
        passedCheck.setExpression(new DynamicValue((Object)true));
        return passedCheck;
    }

    private Check failedCheck() {
        Check failedCheck = new Check();
        failedCheck.setExpression(new DynamicValue((Object)false));
        return failedCheck;
    }

    private Check errorCheck() {
        Check errorCheck = new Check();
        return errorCheck;
    }
}

