/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import org.junit.Assert;
import org.junit.Test;
import step.artefacts.CheckArtefact;
import step.artefacts.IfBlock;
import step.artefacts.RetryIfFails;
import step.artefacts.Set;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;

public class RetryIfFailsHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void testSuccess() {
        this.setupContext();
        RetryIfFails block = this.add(new RetryIfFails());
        block.setMaxRetries(new DynamicValue((Object)2));
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(c -> this.context.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED)), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        junit.framework.Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        junit.framework.Assert.assertEquals((int)1, (int)this.getChildren(child).size());
    }

    @Test
    public void testMaxRetry() {
        this.setupContext();
        RetryIfFails block = this.add(new RetryIfFails());
        block.setMaxRetries(new DynamicValue((Object)2));
        block.setGracePeriod(new DynamicValue((Object)1000));
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(c -> this.context.getCurrentReportNode().setStatus(ReportNodeStatus.FAILED)), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertTrue((child.getDuration() >= 2000 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.FAILED);
        junit.framework.Assert.assertEquals((int)2, (int)this.getChildren(child).size());
    }

    @Test
    public void testTimeout() {
        this.setupContext();
        RetryIfFails block = this.add(new RetryIfFails());
        block.setTimeout(new DynamicValue((Object)200));
        block.setGracePeriod(new DynamicValue((Object)50));
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(c -> {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertTrue((child.getDuration() >= 250 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.FAILED);
    }

    @Test
    public void testFalse() {
        this.setupContext();
        IfBlock block = this.add(new IfBlock("false"));
        this.addAsChildOf(new Set(), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        junit.framework.Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        junit.framework.Assert.assertEquals((int)0, (int)this.getChildren(child).size());
    }
}

