/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.io.File;
import java.util.regex.Pattern;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.execution.ExecutionContext;

public class ExcelFileLookup {
    ExecutionContext context;

    public ExcelFileLookup(ExecutionContext context) {
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File lookup(String workbookPath) {
        if (workbookPath.startsWith("attachment:")) {
            return this.context.getAttachmentManager().getFileById(workbookPath.replace("attachment:", ""));
        }
        if (workbookPath.contains("/")) return new File(workbookPath);
        if (workbookPath.contains("\\")) {
            return new File(workbookPath);
        }
        if (this.context == null) throw new RuntimeException("Unable to lookup workbook '" + workbookPath + "' because the context is null. This should never happen");
        Object o = null;
        if (workbookPath.isEmpty()) {
            Pattern excelFilenamePattern = Pattern.compile("^.*\\.xls(x)?$");
            o = this.context.getVariablesManager().getFirstVariableMatching(excelFilenamePattern);
        } else {
            o = this.context.getVariablesManager().getVariable(ArtefactHandler.FILE_VARIABLE_PREFIX + workbookPath);
        }
        if (o == null) throw new RuntimeException("The workbook '" + workbookPath + "' couldn't be found.");
        if (!(o instanceof File)) throw new RuntimeException("The workbook '" + workbookPath + "' couldn't be found.");
        return (File)o;
    }
}

