/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import step.artefacts.TestScenario;
import step.artefacts.handlers.AtomicReportNodeStatusComposer;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;

public class TestScenarioHandler
extends ArtefactHandler<TestScenario, ReportNode> {
    public void createReportSkeleton_(ReportNode node, TestScenario testArtefact) {
        for (AbstractArtefact child : this.getChildren(testArtefact)) {
            this.delegateCreateReportSkeleton(child, node);
        }
    }

    public void execute_(final ReportNode node, TestScenario testArtefact) {
        final AtomicReportNodeStatusComposer reportNodeStatusComposer = new AtomicReportNodeStatusComposer(node.getStatus());
        List artefacts = this.getChildren(testArtefact);
        ExecutorService executor = Executors.newFixedThreadPool(artefacts.size());
        for (final AbstractArtefact child : artefacts) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    TestScenarioHandler.this.context.associateThread();
                    ReportNode childReportNode = TestScenarioHandler.this.delegateExecute(child, node);
                    reportNodeStatusComposer.addStatusAndRecompose(childReportNode.getStatus());
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            logger.error("An error occcurred while waiting for the executor to terminate", (Throwable)e);
        }
        node.setStatus(reportNodeStatusComposer.getParentStatus());
    }

    public ReportNode createReportNode_(ReportNode parentNode, TestScenario testArtefact) {
        return new ReportNode();
    }
}

