/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import step.artefacts.Set;
import step.artefacts.reports.SetReportNode;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.variables.ImmutableVariableException;
import step.core.variables.UndefinedVariableException;
import step.core.variables.VariablesManager;

public class SetHandler
extends ArtefactHandler<Set, SetReportNode> {
    protected void createReportSkeleton_(SetReportNode parentNode, Set testArtefact) {
        this.executeSet(parentNode, testArtefact);
    }

    protected void execute_(SetReportNode node, Set testArtefact) {
        node.setStatus(ReportNodeStatus.PASSED);
        this.executeSet(node, testArtefact);
    }

    private void executeSet(SetReportNode node, Set testArtefact) {
        if (testArtefact.getKey() != null) {
            Object result = testArtefact.getValue() != null ? testArtefact.getValue().get() : null;
            String key = (String)testArtefact.getKey().get();
            VariablesManager varMan = this.context.getVariablesManager();
            try {
                varMan.updateVariable(key, result);
            }
            catch (ImmutableVariableException | UndefinedVariableException e) {
                ReportNode callFunctionReport = (ReportNode)this.context.getVariablesManager().getVariable("callReport");
                SetReportNode referenceNode = callFunctionReport == null ? node : callFunctionReport;
                ReportNode parentNode = this.context.getReportNodeCache().get(referenceNode.getParentID().toString());
                varMan.putVariable(parentNode, key, result);
            }
            node.setKey(key);
            node.setValue(result != null ? result.toString() : "null");
        }
    }

    public SetReportNode createReportNode_(ReportNode parentNode, Set testArtefact) {
        return new SetReportNode();
    }
}

