/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import step.artefacts.RetryIfFails;
import step.artefacts.Sequence;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;

public class RetryIfFailsHandler
extends ArtefactHandler<RetryIfFails, ReportNode> {
    protected void createReportSkeleton_(ReportNode parentNode, RetryIfFails testArtefact) {
        ArtefactAccessor artefactAccessor = this.context.getArtefactAccessor();
        Sequence iterationTestCase = (Sequence)artefactAccessor.createWorkArtefact(Sequence.class, (AbstractArtefact)testArtefact, "Iteration1", true);
        this.delegateCreateReportSkeleton(iterationTestCase, parentNode);
    }

    protected void execute_(ReportNode node, RetryIfFails testArtefact) {
        ReportNodeStatus lastStatus = ReportNodeStatus.NORUN;
        long begin = System.currentTimeMillis();
        for (int count = 1; count <= (Integer)testArtefact.getMaxRetries().get(); ++count) {
            ArtefactAccessor artefactAccessor = this.context.getArtefactAccessor();
            Sequence iterationTestCase = (Sequence)artefactAccessor.createWorkArtefact(Sequence.class, (AbstractArtefact)testArtefact, "Iteration" + count, true);
            ReportNode iterationReportNode = this.delegateExecute(iterationTestCase, node);
            lastStatus = iterationReportNode.getStatus();
            if (iterationReportNode.getStatus() == ReportNodeStatus.PASSED || this.context.isInterrupted()) break;
            if ((Integer)testArtefact.getTimeout().get() > 0 && System.currentTimeMillis() > begin + (long)((Integer)testArtefact.getTimeout().get()).intValue()) {
                lastStatus = ReportNodeStatus.FAILED;
                break;
            }
            try {
                Thread.sleep(((Integer)testArtefact.getGracePeriod().get()).intValue());
                continue;
            }
            catch (InterruptedException e) {
                lastStatus = ReportNodeStatus.INTERRUPTED;
            }
        }
        node.setStatus(lastStatus);
    }

    public ReportNode createReportNode_(ReportNode parentNode, RetryIfFails testArtefact) {
        return new ReportNode();
    }
}

