/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.file;

import java.io.File;
import junit.framework.Assert;
import org.junit.Test;
import step.commons.helpers.FileHelper;
import step.core.dynamicbeans.DynamicValue;
import step.core.execution.ContextBuilder;
import step.core.execution.ExecutionContext;
import step.core.variables.SimpleStringMap;
import step.datapool.DataPoolConfiguration;
import step.datapool.DataPoolFactory;
import step.datapool.DataSet;
import step.datapool.file.CSVDataPool;

public class CSVReaderDataPoolTest {
    @Test
    public void testCSVReaderDataPool() {
        DataSet<?> pool = this.getDataPool("File.csv");
        Assert.assertEquals((String)"row12", (String)((SimpleStringMap)pool.next().getValue()).get("Col2").toString());
        pool.close();
    }

    @Test
    public void testCSVReaderDataPoolPut() {
        DataSet<?> pool = this.getDataPool("File.csv");
        Exception e = null;
        try {
            ((SimpleStringMap)pool.next().getValue()).put("test", "test");
        }
        catch (Exception ex) {
            e = ex;
        }
        Assert.assertEquals((String)"Put into a CSVRowWrapper row is currently not supported.", (String)e.getMessage());
        pool.close();
    }

    @Test
    public void testCSVReaderDataPoolToString() {
        DataSet<?> pool = this.getDataPool("File.csv");
        Assert.assertEquals((String)"Col1=row11 Col2=row12 Col3=row13", (String)((SimpleStringMap)pool.next().getValue()).toString());
        pool.close();
    }

    protected DataSet<?> getDataPool(String file) {
        CSVDataPool conf = this.getCSVDataSourceConf(file);
        DataSet pool = DataPoolFactory.getDataPool((String)"csv", (DataPoolConfiguration)conf, (ExecutionContext)ContextBuilder.createLocalExecutionContext());
        pool.init();
        return pool;
    }

    private CSVDataPool getCSVDataSourceConf(String filename) {
        File file = FileHelper.getClassLoaderResource(this.getClass(), (String)filename);
        CSVDataPool conf = new CSVDataPool();
        conf.setFile(new DynamicValue((Object)file.getAbsolutePath()));
        return conf;
    }
}

