/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.Set;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.artefacts.reports.SetReportNode;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.variables.VariablesManager;

public class SetVarHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void test() {
        this.setupContext();
        Set set = this.add(new Set());
        set.setKey(new DynamicValue((Object)"var"));
        set.setValue(new DynamicValue((Object)"val1"));
        this.execute((AbstractArtefact)set);
        VariablesManager v = this.context.getVariablesManager();
        Assert.assertEquals((Object)"val1", (Object)v.getVariable("var"));
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals(SetReportNode.class, child.getClass());
        SetReportNode setReport = (SetReportNode)child;
        Assert.assertEquals((String)"val1", (String)setReport.getValue());
        Assert.assertEquals((String)"var", (String)setReport.getKey());
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
    }

    @Test
    public void testObject() {
        this.setupContext();
        Set set = this.add(new Set());
        set.setKey(new DynamicValue((Object)"var"));
        set.setValue(new DynamicValue("2", ""));
        this.execute((AbstractArtefact)set);
        VariablesManager v = this.context.getVariablesManager();
        Assert.assertEquals((Object)2, (Object)v.getVariable("var"));
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals(SetReportNode.class, child.getClass());
        SetReportNode setReport = (SetReportNode)child;
        Assert.assertEquals((String)"2", (String)setReport.getValue());
        Assert.assertEquals((String)"var", (String)setReport.getKey());
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
    }

    @Test
    public void testNull() {
        this.setupContext();
        Set set = this.add(new Set());
        set.setKey(new DynamicValue((Object)"var"));
        set.setValue(new DynamicValue("null", ""));
        this.execute((AbstractArtefact)set);
        VariablesManager v = this.context.getVariablesManager();
        Assert.assertEquals(null, (Object)v.getVariable("var"));
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals(SetReportNode.class, child.getClass());
        SetReportNode setReport = (SetReportNode)child;
        Assert.assertEquals((String)"null", (String)setReport.getValue());
        Assert.assertEquals((String)"var", (String)setReport.getKey());
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
    }
}

