/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.CheckArtefact;
import step.artefacts.Export;
import step.artefacts.Sequence;
import step.commons.helpers.FileHelper;
import step.core.artefacts.AbstractArtefact;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;
import step.core.plans.runner.DefaultPlanRunner;

public class ExportHandlerTest {
    @Test
    public void test() throws IOException {
        File file = this.getTestFolder();
        Export e = new Export();
        e.setValue(new DynamicValue("report.attachments", "groovy"));
        e.getFile().setValue((Object)file.getAbsolutePath());
        this.buildAndRunPlan(e);
        File exceptionLogFile = new File(file.getAbsolutePath() + "/exception.log");
        String firstLine = Files.readFirstLine((File)exceptionLogFile, (Charset)Charset.defaultCharset());
        Assert.assertEquals((String)"java.lang.RuntimeException", (String)firstLine);
        exceptionLogFile.delete();
    }

    @Test
    public void testPrefix() throws IOException {
        File file = this.getTestFolder();
        Export e = new Export();
        e.setPrefix(new DynamicValue((Object)"MyPrefix_"));
        e.setValue(new DynamicValue("report.attachments", "groovy"));
        e.getFile().setValue((Object)file.getAbsolutePath());
        this.buildAndRunPlan(e);
        File exceptionLogFile = new File(file.getAbsolutePath() + "/MyPrefix_exception.log");
        String firstLine = Files.readFirstLine((File)exceptionLogFile, (Charset)Charset.defaultCharset());
        Assert.assertEquals((String)"java.lang.RuntimeException", (String)firstLine);
        exceptionLogFile.delete();
    }

    @Test
    public void testFilter() throws IOException {
        File file = this.getTestFolder();
        Export e = new Export();
        e.setPrefix(new DynamicValue((Object)"MyPrefix2_"));
        e.setValue(new DynamicValue("report.attachments", "groovy"));
        e.getFile().setValue((Object)file.getAbsolutePath());
        e.setFilter(new DynamicValue((Object)"notmatching"));
        this.buildAndRunPlan(e);
        File exceptionLogFile = new File(file.getAbsolutePath() + "/MyPrefix2_exception.log");
        Assert.assertFalse((boolean)exceptionLogFile.exists());
    }

    protected File getTestFolder() {
        File file = FileHelper.getClassLoaderResource(this.getClass(), (String)"exportTest/test");
        file = file.getParentFile();
        return file;
    }

    protected void buildAndRunPlan(Export e) throws IOException {
        Sequence s = new Sequence();
        s.getContinueOnError().setValue((Object)true);
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)s).add((AbstractArtefact)new CheckArtefact(c -> {
            throw new RuntimeException();
        })).add((AbstractArtefact)e).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        runner.run(plan).printTree();
    }
}

