/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import step.artefacts.Export;
import step.attachments.AttachmentMeta;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;

public class ExportHandler
extends ArtefactHandler<Export, ReportNode> {
    protected void createReportSkeleton_(ReportNode parentNode, Export testArtefact) {
        this.export(parentNode, testArtefact);
    }

    protected void execute_(ReportNode node, Export testArtefact) {
        node.setStatus(ReportNodeStatus.PASSED);
        this.export(node, testArtefact);
    }

    private void export(ReportNode node, Export testArtefact) {
        String filename = (String)testArtefact.getFile().get();
        if (filename != null) {
            File file = new File(filename);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (testArtefact.getValue() != null) {
                Object value = testArtefact.getValue().get();
                if (value != null) {
                    if (value instanceof List) {
                        if (file.isDirectory()) {
                            List list = (List)value;
                            for (Object object : list) {
                                if (!(object instanceof AttachmentMeta)) continue;
                                AttachmentMeta attachmentMeta = (AttachmentMeta)object;
                                File fileToCopy = this.context.getAttachmentManager().getFileById(attachmentMeta.getId().toString());
                                File target = new File(file + "/" + fileToCopy.getName());
                                try {
                                    Files.copy((File)fileToCopy, (File)target);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException("Error while copying file " + fileToCopy.getName() + " to " + target.getAbsolutePath());
                                }
                            }
                        } else {
                            this.fail(node, "The folder " + file.getPath() + " is not a directory. Please set the argument 'File' to the export's output directory.");
                        }
                    } else {
                        this.fail(node, "The object defined by the value expression '" + testArtefact.getValue().getExpression() + "' is not a list. The Export control currently only supports the export of attachment lists.");
                    }
                } else {
                    this.fail(node, "The object defined by the value expression '" + testArtefact.getValue().getExpression() + "' is null. Please change the value expression to point to the object to be exported.");
                }
            } else {
                this.fail(node, "The argument 'Value' is null or hasn't been set. Please set the argument 'Value' to the object that should be exported.");
            }
        } else {
            this.fail(node, "The argument 'File' is null or hasn't been set. Please set the argument 'File' to the export's output directory.");
        }
    }

    public ReportNode createReportNode_(ReportNode parentNode, Export testArtefact) {
        return new ReportNode();
    }
}

