/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.file;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import step.attachments.FileResolver;
import step.datapool.DataSet;
import step.datapool.file.FileDataPool;

public abstract class FileReaderDataPool
extends DataSet<FileDataPool> {
    BufferedReader br;
    String filePath;
    int lineNr;

    public FileReaderDataPool(FileDataPool configuration) {
        super((Object)configuration);
    }

    public void init() {
        String file = (String)((FileDataPool)((Object)this.configuration)).getFile().get();
        if (file == null || file.length() < 1) {
            throw new RuntimeException("file path is incorrect.");
        }
        FileResolver fileResolver = new FileResolver(this.context.getAttachmentManager());
        this.filePath = fileResolver.resolve(file).getAbsolutePath();
        this.initReader();
        this.doFirst_();
    }

    private void initReader() {
        FileReader in = null;
        try {
            in = new FileReader(this.filePath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not open file :" + this.filePath + ". error was:" + e.getMessage());
        }
        this.br = new BufferedReader(in);
        this.lineNr = 1;
    }

    public void reset() {
        try {
            this.br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initReader();
        this.doFirst_();
    }

    public abstract void doFirst_();

    public Object next_() {
        String line = this.readOneLine();
        if (line == null) {
            return null;
        }
        return this.postProcess(line);
    }

    protected String readOneLine() {
        String line;
        try {
            line = this.br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not read line from file " + this.filePath + ". Error was:" + e.getMessage());
        }
        ++this.lineNr;
        return line;
    }

    public abstract Object postProcess(String var1);

    public void close() {
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not close reader properly for file " + this.filePath + ". Error was:" + e.getMessage());
        }
    }
}

