/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import step.artefacts.TestSet;
import step.artefacts.handlers.scheduler.DefaultTestSetScheduler;
import step.artefacts.handlers.scheduler.TestCaseBundle;
import step.artefacts.handlers.scheduler.TestSetScheduler;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionManager;

public class TestSetHandler
extends ArtefactHandler<TestSet, ReportNode> {
    public void createReportSkeleton_(ReportNode node, TestSet testSet) {
        ExecutionManager executionManager = new ExecutionManager(this.context.getExecutionAccessor());
        executionManager.updateExecutionType(this.context, "TestSet");
        this.runParallel(node, testSet, false);
    }

    public void execute_(ReportNode node, TestSet testSet) {
        this.runParallel(node, testSet, true);
    }

    private void runParallel(ReportNode node, TestSet testSet, boolean execution) {
        int numberOfThreads = this.context.getVariablesManager().getVariableAsInteger("tec.execution.threads", Integer.valueOf(1));
        DefaultTestSetScheduler scheduler = new DefaultTestSetScheduler();
        List<TestCaseBundle> bundles = ((TestSetScheduler)scheduler).bundleTestCases(this.getChildren(testSet), numberOfThreads);
        ExecutorService executor = Executors.newFixedThreadPool(bundles.size());
        try {
            for (TestCaseBundle bundle : bundles) {
                BundleProcessor bundleProcessor = new BundleProcessor(testSet, bundle, node, execution);
                executor.submit(bundleProcessor);
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            for (TestCaseBundle bundle : bundles) {
                if (bundle.getThrowable() == null) continue;
                throw bundle.getThrowable();
            }
            ReportNodeStatus status = this.context.isInterrupted() ? ReportNodeStatus.INTERRUPTED : ReportNodeStatus.PASSED;
            node.setStatus(status);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    public ReportNode createReportNode_(ReportNode parentNode, TestSet testArtefact) {
        return new ReportNode();
    }

    private class BundleProcessor
    implements Runnable {
        private boolean execution;
        private TestCaseBundle bundle;
        private ReportNode node;

        public BundleProcessor(TestSet testSet, TestCaseBundle bundle, ReportNode node, boolean execution) {
            this.bundle = bundle;
            this.node = node;
            this.execution = execution;
        }

        @Override
        public void run() {
            TestSetHandler.this.context.associateThread();
            try {
                for (AbstractArtefact testArtefact : this.bundle.getTestcases()) {
                    if (!TestSetHandler.this.context.isInterrupted()) {
                        if (this.execution) {
                            TestSetHandler.this.delegateExecute(testArtefact, this.node);
                            continue;
                        }
                        TestSetHandler.this.delegateCreateReportSkeleton(testArtefact, this.node);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.bundle.setThrowable(e);
            }
        }
    }
}

