/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.conf.Configuration;
import step.datapool.excel.CellIndexParser;
import step.datapool.excel.ExcelFileLookup;
import step.datapool.excel.FormulaPatch;
import step.datapool.excel.StyleSyntax;
import step.datapool.excel.WorkbookSet;

public class ExcelFunctions {
    private static Logger logger = LoggerFactory.getLogger(ExcelFunctions.class);
    private static DecimalFormat customDecimalFormat = null;

    public static String getCell(String workbookPath, String sheetName, String cellIndex) {
        ExcelFileLookup excelFileLookup = new ExcelFileLookup(null);
        File workBookFile = excelFileLookup.lookup(workbookPath);
        return ExcelFunctions.getCell(workBookFile, sheetName, cellIndex);
    }

    public static String getCell(File workBookFile, String sheetName, String cellIndex) {
        try (WorkbookSet workbookSet = new WorkbookSet(workBookFile, ExcelFunctions.getMaxExcelSize(), false, false);){
            String result;
            Sheet sheet = ExcelFunctions.getSheet(workbookSet, sheetName, false);
            Cell cell = ExcelFunctions.getCell(sheet, cellIndex, false);
            FormulaEvaluator evaluator = workbookSet.getMainFormulaEvaluator();
            String string = result = ExcelFunctions.getCellValueAsString(cell, evaluator);
            return string;
        }
    }

    protected static Sheet getSheet(WorkbookSet workbookSet, String sheetName, boolean createIfNotExists) {
        Sheet sheet = workbookSet.getMainWorkbook().getSheet(sheetName);
        if (sheet != null) {
            return sheet;
        }
        if (createIfNotExists) {
            return workbookSet.getMainWorkbook().createSheet(sheetName);
        }
        throw new RuntimeException("The sheet '" + sheetName + "' doesn't exist");
    }

    private static Cell getCell(Sheet sheet, String cellIndex, boolean createIfNotExists) {
        Cell cell;
        CellIndexParser.CellIndex index = CellIndexParser.parse(cellIndex);
        Row row = sheet.getRow(index.getRowNum());
        if (row == null) {
            if (createIfNotExists) {
                row = sheet.createRow(index.getRowNum());
            } else {
                throw new RuntimeException("The row of the cell " + cellIndex + " doesn't exist or is empty");
            }
        }
        if ((cell = row.getCell(index.getColNum())) == null) {
            if (createIfNotExists) {
                cell = row.createCell(index.getColNum());
            } else {
                throw new RuntimeException("The cell '" + cellIndex + "' doesn't exist or is empty");
            }
        }
        return cell;
    }

    public static void putCell(String workbookPath, String sheetName, String cellIndex, String cellValue, String style) throws IOException {
        File workBookFile = new File(workbookPath);
        try (WorkbookSet workbookSet = new WorkbookSet(workBookFile, ExcelFunctions.getMaxExcelSize(), true, true);){
            Sheet sheet = ExcelFunctions.getSheet(workbookSet, sheetName, true);
            Cell cell = ExcelFunctions.getCell(sheet, cellIndex, true);
            XSSFCellStyle cellStyle = StyleSyntax.composeStyle(style, workbookSet.getMainWorkbook());
            if (cellStyle != null) {
                cell.setCellStyle((CellStyle)cellStyle);
            }
            cell.setCellValue(cellValue);
            workbookSet.save();
        }
    }

    protected static Integer getMaxExcelSize() {
        return Configuration.getInstance().getPropertyAsInteger("tec.maxexcelsize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueAsString(Cell cell, FormulaEvaluator evaluator) {
        String formula;
        boolean isFormulaPatched = false;
        String initialFormula = null;
        int chkTyp = cell.getCellType();
        if (chkTyp == 2 && !(formula = FormulaPatch.patch(initialFormula = cell.getCellFormula())).equals(initialFormula)) {
            isFormulaPatched = true;
            cell.setCellFormula(formula);
            evaluator.notifySetFormula(cell);
        }
        try {
            int typ = ExcelFunctions.evaluateFormulaCell(cell, evaluator);
            if (typ == -1) {
                typ = cell.getCellType();
            }
            switch (typ) {
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date dat = cell.getDateCellValue();
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(dat);
                        if (cal.get(1) < 1900) {
                            SimpleDateFormat STD_TIM = new SimpleDateFormat("kk:mm:ss");
                            String string = STD_TIM.format(dat);
                            return string;
                        }
                        SimpleDateFormat STD_DAT = new SimpleDateFormat("dd.MM.yyyy");
                        String string = STD_DAT.format(dat);
                        return string;
                    }
                    double dbl = cell.getNumericCellValue();
                    int tryInt = (int)dbl;
                    long tryLong = (long)dbl;
                    if ((double)tryInt == dbl) {
                        String string = new Integer(tryInt).toString();
                        return string;
                    }
                    if ((double)tryLong == dbl) {
                        String string = new Long(tryLong).toString();
                        return string;
                    }
                    String numberValueString = new Double(dbl).toString();
                    try {
                        BigDecimal roundedBigDecimal = new BigDecimal(numberValueString).setScale(14, RoundingMode.HALF_UP);
                        String customValueString = ExcelFunctions.getCustomDecimalFormat().format(roundedBigDecimal);
                        if (!customValueString.equals(numberValueString)) {
                            logger.debug("getCellValusAsString: Changing string value of double '{}' to '{}'", (Object)numberValueString, (Object)customValueString);
                            numberValueString = customValueString;
                        }
                    }
                    catch (Exception e) {
                        logger.error("An error occurred trying to convert the cell value number to decimal format " + numberValueString, (Throwable)e);
                    }
                    String string = numberValueString;
                    return string;
                }
                case 4: {
                    String string = Boolean.toString(cell.getBooleanCellValue());
                    return string;
                }
                case 2: {
                    String string = cell.getCellFormula();
                    return string;
                }
                case 1: {
                    String string = cell.getRichStringCellValue().getString();
                    return string;
                }
                case 3: {
                    String string = "";
                    return string;
                }
                case 5: {
                    switch (cell.getErrorCellValue()) {
                        case 1: {
                            String string = "#NULL!";
                            return string;
                        }
                        case 2: {
                            String string = "#DIV/0!";
                            return string;
                        }
                        case 3: {
                            String string = "#VALUE!";
                            return string;
                        }
                        case 4: {
                            String string = "#REF!";
                            return string;
                        }
                        case 5: {
                            String string = "#NAME?";
                            return string;
                        }
                        case 6: {
                            String string = "#NUM!";
                            return string;
                        }
                        case 7: {
                            String string = "#N/A";
                            return string;
                        }
                    }
                    String string = "#ERR!";
                    return string;
                }
            }
            String string = "ERROR: unknown Format";
            return string;
        }
        finally {
            if (isFormulaPatched) {
                cell.setCellFormula(initialFormula);
                evaluator.notifySetFormula(cell);
            }
        }
    }

    private static int evaluateFormulaCell(Cell cell, FormulaEvaluator evaluator) {
        int typ = -1;
        try {
            typ = evaluator.evaluateFormulaCell(cell);
        }
        catch (RuntimeException e) {
            String cellRef = CellReference.convertNumToColString((int)cell.getColumnIndex()) + (cell.getRowIndex() + 1);
            String errMsg = "Error while evaluating cell " + cellRef + " from sheet " + cell.getSheet().getSheetName() + ": " + e.getMessage();
            throw new RuntimeException(errMsg, e);
        }
        return typ;
    }

    private static DecimalFormat getCustomDecimalFormat() {
        if (customDecimalFormat == null) {
            customDecimalFormat = new DecimalFormat("#.##############", DecimalFormatSymbols.getInstance(Locale.ROOT));
        }
        return customDecimalFormat;
    }
}

