/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import step.artefacts.Export;
import step.attachments.AttachmentMeta;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;

public class ExportHandler
extends ArtefactHandler<Export, ReportNode> {
    protected void createReportSkeleton_(ReportNode parentNode, Export testArtefact) {
        this.export(parentNode, testArtefact);
    }

    protected void execute_(ReportNode node, Export testArtefact) {
        node.setStatus(ReportNodeStatus.PASSED);
        this.export(node, testArtefact);
    }

    private void export(ReportNode node, Export testArtefact) {
        String filename = (String)testArtefact.getFile().get();
        if (filename != null) {
            Object value;
            File file = new File(filename);
            if (testArtefact.getValue() != null && (value = testArtefact.getValue().get()) instanceof List && file.isDirectory()) {
                List list = (List)value;
                for (Object object : list) {
                    if (!(object instanceof AttachmentMeta)) continue;
                    AttachmentMeta attachmentMeta = (AttachmentMeta)object;
                    File fileToCopy = this.context.getAttachmentManager().getFileById(attachmentMeta.getId().toString());
                    File target = new File(file + "/" + fileToCopy.getName());
                    try {
                        Files.copy((File)fileToCopy, (File)target);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error while copying file " + fileToCopy.getName() + " to " + target.getAbsolutePath());
                    }
                }
            }
        }
    }

    public ReportNode createReportNode_(ReportNode parentNode, Export testArtefact) {
        return new ReportNode();
    }
}

