/*
 * Decompiled with CFR 0.152.
 */
package step.planbuilder;

import java.io.File;
import java.util.Stack;
import step.artefacts.ForBlock;
import step.artefacts.ForEachBlock;
import step.artefacts.Sequence;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.InMemoryArtefactAccessor;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.Plan;
import step.datapool.excel.ExcelDataPool;
import step.datapool.sequence.IntSequenceDataPool;

public class PlanBuilder {
    protected AbstractArtefact root;
    protected InMemoryArtefactAccessor localAccessor = new InMemoryArtefactAccessor();
    protected Stack<AbstractArtefact> stack = new Stack();

    public static PlanBuilder create() {
        return new PlanBuilder();
    }

    public Plan build() {
        return new Plan(this.root, this.localAccessor.getCollection());
    }

    public PlanBuilder add(AbstractArtefact artefact) {
        if (this.root == null) {
            this.startBlock(PlanBuilder.sequence());
        }
        this.localAccessor.save(artefact);
        this.addToCurrentParent(artefact);
        return this;
    }

    public PlanBuilder startBlock(AbstractArtefact a) {
        if (this.root != null) {
            this.addToCurrentParent(a);
        } else {
            this.root = a;
        }
        this.localAccessor.save(a);
        this.stack.push(a);
        return this;
    }

    public PlanBuilder endBlock() {
        this.stack.pop();
        return this;
    }

    private void addToCurrentParent(AbstractArtefact artefact) {
        AbstractArtefact parent = this.stack.peek();
        this.localAccessor.get(parent.getId()).addChild(artefact.getId());
    }

    public static Sequence sequence() {
        return new Sequence();
    }

    public static ForBlock for_(int start, int end) {
        ForBlock f = new ForBlock();
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setStart((DynamicValue<Integer>)new DynamicValue((Object)start));
        conf.setEnd((DynamicValue<Integer>)new DynamicValue((Object)end));
        f.setDataSource(conf);
        return f;
    }

    public static ForEachBlock forEachRowInExcel(File file) {
        ForEachBlock f = new ForEachBlock();
        ExcelDataPool p = new ExcelDataPool();
        p.setFile((DynamicValue<String>)new DynamicValue((Object)file.getAbsolutePath()));
        p.getHeaders().setValue((Object)true);
        f.setDataSource(p);
        f.setDataSourceType("excel");
        return f;
    }
}

