/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.file;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import step.core.variables.SimpleStringMap;
import step.datapool.file.CSVDataPool;
import step.datapool.file.FileReaderDataPool;

public class CSVReaderDataPool
extends FileReaderDataPool {
    Vector<String> headers;
    String delimiter;

    public CSVReaderDataPool(CSVDataPool configuration) {
        super(configuration);
        this.delimiter = (String)configuration.getDelimiter().get();
    }

    @Override
    public Object postProcess(String line) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Vector<String> csv = this.splitCSV(line);
            for (int i = 0; i < csv.size(); ++i) {
                map.put(this.headers.get(i), csv.get(i));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException(e.getMessage() + " : headers=" + this.headers + "; row=" + line + "; delimiter=" + this.delimiter);
        }
        return new CSVRowWrapper(this.lineNr, map);
    }

    public Vector<String> getHeaders(String readOneLine) {
        return this.splitCSV(readOneLine);
    }

    public Vector<String> splitCSV(String readOneLine) {
        Vector<String> v = new Vector<String>();
        for (String s : readOneLine.split(this.delimiter)) {
            v.add(s);
        }
        return v;
    }

    @Override
    public void doFirst_() {
        this.headers = this.getHeaders(this.readOneLine());
    }

    public void addRow(Object row) {
        throw new RuntimeException("Not implemented");
    }

    public class CSVRowWrapper
    extends SimpleStringMap {
        private HashMap<String, Object> rowData;

        public CSVRowWrapper(int rowNum, HashMap<String, Object> row) {
            if (rowNum < 1) {
                throw new RuntimeException("Invalid row number:" + rowNum);
            }
            this.rowData = row;
        }

        public String put(String key, String value) {
            throw new RuntimeException("Put into a CSVRowWrapper row is currently not supported.");
        }

        public String get(String key) {
            return (String)this.rowData.get(key);
        }

        public int size() {
            return this.rowData.size();
        }

        public boolean isEmpty() {
            return this.rowData.isEmpty();
        }

        public Set<String> keySet() {
            return new HashSet<String>(CSVReaderDataPool.this.headers);
        }
    }
}

