/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import step.artefacts.Sequence;
import step.artefacts.ThreadGroup;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;

public class ThreadGroupHandler
extends ArtefactHandler<ThreadGroup, ReportNode> {
    public void createReportSkeleton_(ReportNode node, ThreadGroup testArtefact) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute_(final ReportNode node, final ThreadGroup testArtefact) {
        Integer numberOfUsers = (Integer)testArtefact.getUsers().get();
        if (numberOfUsers == null || numberOfUsers <= 0) {
            throw new RuntimeException("Invalid argument: 'users' has to be higher than 0.");
        }
        final int numberOfIterations = (Integer)testArtefact.getIterations().get();
        final int pacing = testArtefact.getPacing().get() != null ? (Integer)testArtefact.getPacing().get() : 0;
        long rampup = testArtefact.getRampup().get() != null ? (long)((Integer)testArtefact.getRampup().get()).intValue() : (long)pacing;
        final LongAdder gcounter = new LongAdder();
        ExecutorService executor = Executors.newFixedThreadPool(numberOfUsers);
        try {
            int j = 0;
            while (j < numberOfUsers) {
                final int groupID = j++;
                final long localStartOffset = (long)((Integer)testArtefact.getStartOffset().get()).intValue() + (long)(1.0 * (double)groupID / (double)numberOfUsers.intValue() * (double)rampup);
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            ExecutionContext.setCurrentContext((ExecutionContext)ThreadGroupHandler.this.context);
                            ReportNode iterationReportNode = null;
                            try {
                                Thread.sleep(localStartOffset);
                                for (int i = 0; i < numberOfIterations; ++i) {
                                    long startTime = System.currentTimeMillis();
                                    gcounter.increment();
                                    if (!ThreadGroupHandler.this.context.isInterrupted()) {
                                        ArtefactAccessor artefactAccessor = ThreadGroupHandler.this.context.getGlobalContext().getArtefactAccessor();
                                        Sequence iterationTestCase = (Sequence)artefactAccessor.createWorkArtefact(Sequence.class, (AbstractArtefact)testArtefact, "Group_" + groupID + "_Iteration_" + i);
                                        for (AbstractArtefact child : ThreadGroupHandler.this.getChildren(testArtefact)) {
                                            iterationTestCase.addChild(child.getId());
                                        }
                                        HashMap<Object, Integer> newVariable = new HashMap<Object, Integer>();
                                        newVariable.put(testArtefact.getLocalItem().get(), i);
                                        newVariable.put(testArtefact.getUserItem().get(), groupID);
                                        newVariable.put(testArtefact.getItem().get(), gcounter.intValue());
                                        iterationReportNode = ArtefactHandler.delegateExecute((ExecutionContext)ThreadGroupHandler.this.context, (AbstractArtefact)iterationTestCase, (ReportNode)node, newVariable);
                                        if (pacing == 0) continue;
                                        long endTime = System.currentTimeMillis();
                                        long duration = endTime - startTime;
                                        long pacingWait = (long)pacing - duration;
                                        if (pacingWait > 0L) {
                                            Thread.sleep(pacingWait);
                                            continue;
                                        }
                                        logger.warn("Pacing of TestGroup " + testArtefact.getId() + " in test " + ThreadGroupHandler.this.context.getExecutionId() + " exceeded. The iteration lasted " + duration + "ms. The defined pacing was: " + testArtefact.getPacing() + "ms.");
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Exception e) {
                                if (iterationReportNode == null) break block6;
                                ThreadGroupHandler.this.failWithException(iterationReportNode, e);
                            }
                        }
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.DAYS);
            node.setStatus(ReportNodeStatus.PASSED);
        }
        catch (InterruptedException e) {
            this.failWithException(node, e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    public ReportNode createReportNode_(ReportNode parentNode, ThreadGroup testArtefact) {
        return new ReportNode();
    }
}

