/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import step.artefacts.DataSetArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ReportNodeEventListener;
import step.core.variables.VariableType;
import step.datapool.DataPoolFactory;
import step.datapool.DataPoolRow;
import step.datapool.DataSet;
import step.datapool.DataSetHandle;

public class DataSetHandler
extends ArtefactHandler<DataSetArtefact, ReportNode> {
    public void createReportSkeleton_(ReportNode node, DataSetArtefact testArtefact) {
        this.initDataSetAndAddItToContext(node, testArtefact);
    }

    public void execute_(ReportNode node, DataSetArtefact testArtefact) {
        this.initDataSetAndAddItToContext(node, testArtefact);
    }

    private void initDataSetAndAddItToContext(ReportNode node, DataSetArtefact testArtefact) {
        try {
            final DataSet<?> dataSet = DataPoolFactory.getDataPool(testArtefact.getDataSourceType(), testArtefact.getDataSource(), this.context);
            dataSet.init();
            ReportNode parentNode = this.context.getReportNodeCache().get(node.getParentID().toString());
            this.context.getVariablesManager().putVariable(parentNode, VariableType.NORMAL, (String)testArtefact.getItem().get(), (Object)new DataSetWrapper(testArtefact, dataSet));
            this.context.getGlobalContext().getEventManager().addReportNodeEventListener(parentNode, new ReportNodeEventListener(){

                public void onDestroy() {
                    try {
                        dataSet.save();
                    }
                    finally {
                        dataSet.close();
                    }
                }
            });
            node.setStatus(ReportNodeStatus.PASSED);
        }
        catch (Exception e) {
            this.failWithException(node, e);
        }
    }

    public ReportNode createReportNode_(ReportNode parentNode, DataSetArtefact testArtefact) {
        return new ReportNode();
    }

    public static class DataSetWrapper
    implements DataSetHandle {
        DataSet<?> dataSet;
        DataSetArtefact artefact;

        public DataSetWrapper(DataSetArtefact artefact, DataSet<?> dataSet) {
            this.dataSet = dataSet;
            this.artefact = artefact;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object next() {
            DataSet<?> dataSet = this.dataSet;
            synchronized (dataSet) {
                DataPoolRow row = this.dataSet.next();
                if (row == null && ((Boolean)this.artefact.getResetAtEnd().get()).booleanValue()) {
                    this.dataSet.reset();
                    row = this.dataSet.next();
                }
                return row != null ? row.getValue() : null;
            }
        }

        public final void addRow(Object row) {
            this.dataSet.addRow(row);
        }
    }
}

