/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.HashMap;
import java.util.List;
import step.artefacts.Sequence;
import step.artefacts.While;
import step.artefacts.reports.WhileReportNode;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.dynamicbeans.DynamicValueResolver;
import step.core.execution.ExecutionContext;

public class WhileHandler
extends ArtefactHandler<While, WhileReportNode> {
    protected void createReportSkeleton_(WhileReportNode parentNode, While testArtefact) {
        this.evaluateExpressionAndDelegate(parentNode, testArtefact, false);
    }

    protected void execute_(WhileReportNode node, While testArtefact) {
        this.evaluateExpressionAndDelegate(node, testArtefact, true);
    }

    private void evaluateExpressionAndDelegate(WhileReportNode node, While testArtefact, boolean execution) {
        Long timeoutValue = (Long)testArtefact.getTimeout().get();
        long timeout = timeoutValue == null ? 0L : timeoutValue;
        long maxTime = System.currentTimeMillis() + timeout;
        Integer maxIterationsValue = (Integer)testArtefact.getMaxIterations().get();
        int maxIterations = maxIterationsValue == null ? 0 : maxIterationsValue;
        int failedLoops = 0;
        Long pacingValue = (Long)testArtefact.getPacing().get();
        long pacing = pacingValue == null ? 0L : pacingValue;
        List selectedChildren = this.getChildren(testArtefact);
        DynamicValueResolver resolver = new DynamicValueResolver(this.context.getGlobalContext().getExpressionHandler());
        DynamicValue<Boolean> condition = testArtefact.getCondition();
        ArtefactAccessor artefactAccessor = this.context.getGlobalContext().getArtefactAccessor();
        try {
            int currIterationsCount;
            for (currIterationsCount = 0; !(!this.reevaluateCondition(resolver, condition) || !((Boolean)condition.get()).booleanValue() || timeout != 0L && System.currentTimeMillis() >= maxTime || maxIterations != 0 && currIterationsCount >= maxIterations || this.context.isInterrupted()); ++currIterationsCount) {
                Sequence iterationTestCase = (Sequence)artefactAccessor.createWorkArtefact(Sequence.class, (AbstractArtefact)testArtefact, "Iteration_" + currIterationsCount);
                iterationTestCase.setPacing((DynamicValue<Long>)new DynamicValue((Object)pacing));
                for (AbstractArtefact child : selectedChildren) {
                    iterationTestCase.addChild(child.getId());
                }
                if (execution) {
                    ReportNode iterationReportNode = WhileHandler.delegateExecute((ExecutionContext)this.context, (AbstractArtefact)iterationTestCase, (ReportNode)node, new HashMap());
                    if (iterationReportNode.getStatus() != ReportNodeStatus.TECHNICAL_ERROR && iterationReportNode.getStatus() != ReportNodeStatus.FAILED) continue;
                    ++failedLoops;
                    continue;
                }
                ArtefactHandler.delegateCreateReportSkeleton((ExecutionContext)this.context, (AbstractArtefact)iterationTestCase, (ReportNode)node);
            }
            node.setErrorCount(failedLoops);
            node.setCount(currIterationsCount);
            if (failedLoops > 0) {
                node.setStatus(ReportNodeStatus.FAILED);
            } else {
                node.setStatus(ReportNodeStatus.PASSED);
            }
        }
        catch (Exception e) {
            this.failWithException(node, e);
        }
    }

    protected boolean reevaluateCondition(DynamicValueResolver resolver, DynamicValue<Boolean> condition) {
        resolver.evaluate(condition, this.getBindings());
        return true;
    }

    public WhileReportNode createReportNode_(ReportNode parentNode, While testArtefact) {
        return new WhileReportNode();
    }
}

