/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.HashMap;
import java.util.List;
import step.artefacts.Sequence;
import step.artefacts.WaitAndPoll;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.dynamicbeans.DynamicValueResolver;
import step.core.execution.ExecutionContext;

public class WaitAndPollHandler
extends ArtefactHandler<WaitAndPoll, ReportNode> {
    protected void createReportSkeleton_(ReportNode parentNode, WaitAndPoll testArtefact) {
        this.evaluateExpressionAndDelegate(parentNode, testArtefact, false);
    }

    protected void execute_(ReportNode node, WaitAndPoll testArtefact) {
        this.evaluateExpressionAndDelegate(node, testArtefact, true);
    }

    private void evaluateExpressionAndDelegate(ReportNode node, WaitAndPoll testArtefact, boolean execution) {
        Long timeoutValue = (Long)testArtefact.getTimeout().get();
        long timeout = timeoutValue == null ? 0L : timeoutValue;
        long maxTime = System.currentTimeMillis() + timeout;
        Integer maxIterationsValue = (Integer)testArtefact.getMaxIterations().get();
        int maxIterations = maxIterationsValue == null ? 0 : maxIterationsValue;
        int failedLoops = 0;
        Long pacingValue = (Long)testArtefact.getPacing().get();
        long pacing = pacingValue == null ? 0L : pacingValue;
        List selectedChildren = this.getChildren(testArtefact);
        DynamicValueResolver resolver = new DynamicValueResolver(this.context.getGlobalContext().getExpressionHandler());
        ArtefactAccessor artefactAccessor = this.context.getGlobalContext().getArtefactAccessor();
        ReportNodeStatus pollingStatus = null;
        try {
            int currIterationsCount;
            for (currIterationsCount = 0; !(pollingStatus != null && pollingStatus == ReportNodeStatus.PASSED || timeout != 0L && System.currentTimeMillis() >= maxTime || maxIterations != 0 && currIterationsCount >= maxIterations || this.context.isInterrupted()); ++currIterationsCount) {
                Sequence iterationTestCase = (Sequence)artefactAccessor.createWorkArtefact(Sequence.class, (AbstractArtefact)testArtefact, "Iteration_" + currIterationsCount);
                iterationTestCase.setPacing((DynamicValue<Long>)new DynamicValue((Object)pacing));
                for (AbstractArtefact child : selectedChildren) {
                    iterationTestCase.addChild(child.getId());
                }
                if (execution) {
                    ReportNode iterationReportNode = WaitAndPollHandler.delegateExecute((ExecutionContext)this.context, (AbstractArtefact)iterationTestCase, (ReportNode)node, new HashMap());
                    pollingStatus = iterationReportNode.getStatus();
                    if (iterationReportNode.getStatus() != ReportNodeStatus.TECHNICAL_ERROR && iterationReportNode.getStatus() != ReportNodeStatus.FAILED) continue;
                    ++failedLoops;
                    continue;
                }
                ArtefactHandler.delegateCreateReportSkeleton((ExecutionContext)this.context, (AbstractArtefact)iterationTestCase, (ReportNode)node);
            }
            node.addCustomAttribute("failedLoopCount", Integer.toString(failedLoops));
            node.addCustomAttribute("LoopCount", Integer.toString(currIterationsCount));
            if (failedLoops > 0) {
                node.setStatus(ReportNodeStatus.FAILED);
            } else {
                node.setStatus(ReportNodeStatus.PASSED);
            }
        }
        catch (Exception e) {
            this.failWithException(node, e);
        }
    }

    public ReportNode createReportNode_(ReportNode parentNode, WaitAndPoll testArtefact) {
        return new ReportNode();
    }
}

